/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.search;

import io.gravitee.rest.api.idp.api.identity.SearchableUser;
import io.gravitee.rest.api.service.IdentityService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Tag(name="Users")
public class SearchUsersResource {
    @Inject
    private IdentityService identityService;
    private static final Comparator<String> CASE_INSENSITIVE_ORDER = new CaseInsensitiveComparator();

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Search for users")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of users", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=SearchableUser.class)))}), @ApiResponse(responseCode="400", description="Bad query parameter"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Collection<SearchableUser> searchUsers(@Parameter(name="q", required=true) @NotNull @QueryParam(value="q") String query) {
        return this.identityService.search(query).stream().sorted((o1, o2) -> CASE_INSENSITIVE_ORDER.compare(o1.getLastname(), o2.getLastname())).collect(Collectors.toList());
    }

    private static class CaseInsensitiveComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 8575799808933029326L;

        private CaseInsensitiveComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            if (s1 == null) {
                return 1;
            }
            if (s2 == null) {
                return -1;
            }
            int n1 = s1.length();
            int n2 = s2.length();
            int min = Math.min(n1, n2);
            for (int i = 0; i < min; ++i) {
                char c2;
                char c1 = s1.charAt(i);
                if (c1 == (c2 = s2.charAt(i)) || (c1 = Character.toUpperCase(c1)) == (c2 = Character.toUpperCase(c2)) || (c1 = Character.toLowerCase(c1)) == (c2 = Character.toLowerCase(c2))) continue;
                return c1 - c2;
            }
            return n1 - n2;
        }

        private Object readResolve() {
            return CASE_INSENSITIVE_ORDER;
        }
    }
}

