/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.model.wrapper.PlatformRequestItemSearchLogResponse;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.param.LogsParam;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.analytics.query.LogQuery;
import io.gravitee.rest.api.model.log.ApiRequest;
import io.gravitee.rest.api.model.log.PlatformRequestItem;
import io.gravitee.rest.api.model.log.SearchLogResponse;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.LogsService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.inject.Inject;
import javax.ws.rs.BeanParam;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Tag(name="Platform Logs")
public class PlatformLogsResource
extends AbstractResource {
    @Inject
    private LogsService logsService;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Get platform logs", description="User must have the MANAGEMENT_PLATFORM[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Platform logs", content={@Content(mediaType="application/json", schema=@Schema(implementation=PlatformRequestItemSearchLogResponse.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_PLATFORM, acls={RolePermissionAction.READ})})
    public SearchLogResponse<PlatformRequestItem> getPlatformLogs(@BeanParam LogsParam param) {
        param.validate();
        LogQuery logQuery = new LogQuery();
        logQuery.setQuery(param.getQuery());
        logQuery.setPage(param.getPage());
        logQuery.setSize(param.getSize());
        logQuery.setFrom(param.getFrom());
        logQuery.setTo(param.getTo());
        logQuery.setField(param.getField());
        logQuery.setOrder(param.isOrder());
        return this.logsService.findPlatform(GraviteeContext.getExecutionContext(), logQuery);
    }

    @GET
    @Path(value="/{log}")
    @Produces(value={"application/json"})
    @Operation(summary="Get a specific log", description="User must have the MANAGEMENT_PLATFORM[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Single log", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiRequest.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_PLATFORM, acls={RolePermissionAction.READ})})
    public ApiRequest getPlatformLog(@PathParam(value="log") String logId, @QueryParam(value="timestamp") Long timestamp) {
        return this.logsService.findApiLog(GraviteeContext.getExecutionContext(), logId, timestamp);
    }

    @GET
    @Path(value="export")
    @Produces(value={"text/csv"})
    @Operation(summary="Export platform logs as CSV", description="User must have the MANAGEMENT_PLATFORM[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Platform logs as CSV", content={@Content(mediaType="text/csv", schema=@Schema(type="string"))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_PLATFORM, acls={RolePermissionAction.READ})})
    public Response exportPlatformLogsAsCSV(@BeanParam LogsParam param) {
        SearchLogResponse<PlatformRequestItem> searchLogResponse = this.getPlatformLogs(param);
        return Response.ok((Object)this.logsService.exportAsCsv(GraviteeContext.getExecutionContext(), searchLogResponse)).header("Content-Disposition", (Object)String.format("attachment;filename=logs-%s-%s.csv", "platform", System.currentTimeMillis())).build();
    }
}

