/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.ApplicationApiKeyResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.ApiKeyEntity;
import io.gravitee.rest.api.model.ApplicationEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.ApiKeyService;
import io.gravitee.rest.api.service.ApplicationService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.ApplicationNotFoundException;
import io.gravitee.rest.api.service.exceptions.InvalidApplicationApiKeyModeException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.net.URI;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Tag(name="API Keys")
public class ApplicationApiKeysResource
extends AbstractResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private ApiKeyService apiKeyService;
    @Inject
    private ApplicationService applicationService;
    @PathParam(value="application")
    @Parameter(name="application", hidden=true)
    private String application;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="List all API Keys for an application", description="User must have the READ permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of API Keys for application", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=ApiKeyEntity.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_SUBSCRIPTION, acls={RolePermissionAction.READ})})
    public List<ApiKeyEntity> getApiKeysForApplication() {
        return this.apiKeyService.findByApplication(GraviteeContext.getExecutionContext(), this.application);
    }

    @POST
    @Path(value="/_renew")
    @Produces(value={"application/json"})
    @Operation(summary="Renew an API key", description="User must have the MANAGE_API_KEYS permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="A new API Key", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiKeyEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_SUBSCRIPTION, acls={RolePermissionAction.UPDATE})})
    public Response renewApiKeyForApplicationSubscription() {
        ApplicationEntity applicationEntity = this.getApplication();
        this.checkApplicationApiKeyModeAllowed(applicationEntity);
        ApiKeyEntity apiKeyEntity = this.apiKeyService.renew(GraviteeContext.getExecutionContext(), applicationEntity);
        URI location = URI.create(this.uriInfo.getPath().replace("_renew", apiKeyEntity.getId()));
        return Response.created((URI)location).entity((Object)apiKeyEntity).build();
    }

    @Path(value="{apikey}")
    public ApplicationApiKeyResource getApplicationApiKeyResource() {
        this.checkApplicationApiKeyModeAllowed(this.getApplication());
        return (ApplicationApiKeyResource)this.resourceContext.getResource(ApplicationApiKeyResource.class);
    }

    private ApplicationEntity getApplication() {
        ApplicationEntity applicationEntity = this.applicationService.findById(GraviteeContext.getExecutionContext(), this.application);
        if (applicationEntity == null) {
            throw new ApplicationNotFoundException(this.application);
        }
        return applicationEntity;
    }

    private void checkApplicationApiKeyModeAllowed(ApplicationEntity applicationEntity) {
        if (!applicationEntity.hasApiKeySharedMode()) {
            throw new InvalidApplicationApiKeyModeException("Can't access ApiKey by Application cause it's not a shared Api Key");
        }
    }
}

