/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.model.ApplicationEntity;
import io.gravitee.rest.api.model.SubscriptionEntity;
import io.gravitee.rest.api.model.SubscriptionStatus;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.subscription.SubscriptionQuery;
import io.gravitee.rest.api.service.ApplicationService;
import io.gravitee.rest.api.service.SubscriptionService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.ForbiddenAccessException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;

@Tag(name="API Subscriptions")
public class ApiSubscribersResource
extends AbstractResource {
    @Inject
    private SubscriptionService subscriptionService;
    @Inject
    private ApplicationService applicationService;
    @Context
    private ResourceContext resourceContext;
    @PathParam(value="api")
    @Parameter(name="api", hidden=true)
    private String api;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="List subscribers for the API", description="User must have the MANAGE_SUBSCRIPTIONS permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Paged result of API subscribers", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=ApplicationEntity.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public Collection<ApplicationEntity> getApiSubscribers() {
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        if (!this.hasPermission(executionContext, RolePermission.API_SUBSCRIPTION, this.api, RolePermissionAction.READ) && !this.hasPermission(executionContext, RolePermission.API_LOG, this.api, RolePermissionAction.READ)) {
            throw new ForbiddenAccessException();
        }
        SubscriptionQuery subscriptionQuery = new SubscriptionQuery();
        subscriptionQuery.setApi(this.api);
        subscriptionQuery.setStatuses(Set.of(SubscriptionStatus.PENDING, SubscriptionStatus.ACCEPTED));
        Collection subscriptions = this.subscriptionService.search(executionContext, subscriptionQuery);
        return subscriptions.stream().map(SubscriptionEntity::getApplication).distinct().map(application -> this.applicationService.findById(executionContext, application)).sorted((o1, o2) -> String.CASE_INSENSITIVE_ORDER.compare(o1.getName(), o2.getName())).collect(Collectors.toList());
    }
}

