/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.GroupResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.GroupEntity;
import io.gravitee.rest.api.model.NewGroupEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.GroupService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.net.URI;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Tag(name="Groups")
public class GroupsResource
extends AbstractResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private GroupService groupService;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Find groups", description="Find all groups, or a specific type of groups.Only administrators could see all groups.Only users with MANAGE_API permissions could see API groups.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of groups", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=GroupEntity.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_GROUP, acls={RolePermissionAction.READ})})
    public Response getGroups() {
        return Response.ok((Object)this.groupService.findAll(GraviteeContext.getExecutionContext())).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Operation(summary="Create group", description="Create a new group.")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Group successfully created", content={@Content(mediaType="application/json", schema=@Schema(implementation=GroupEntity.class))}), @ApiResponse(responseCode="500", description="Internal Server Error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_GROUP, acls={RolePermissionAction.CREATE})})
    public Response createGroup(@Parameter(name="group", required=true) @Valid @NotNull NewGroupEntity newGroupEntity) {
        GroupEntity groupEntity = this.groupService.create(GraviteeContext.getExecutionContext(), newGroupEntity);
        if (groupEntity != null) {
            return Response.created((URI)this.getLocationHeader(groupEntity.getId())).entity((Object)groupEntity).build();
        }
        return Response.serverError().build();
    }

    @Path(value="{group}")
    public GroupResource groupResource() {
        return (GroupResource)this.resourceContext.getResource(GroupResource.class);
    }
}

