/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.common.data.domain.Page;
import io.gravitee.common.event.EventManager;
import io.gravitee.rest.api.management.rest.model.GroupMembership;
import io.gravitee.rest.api.management.rest.model.Pageable;
import io.gravitee.rest.api.management.rest.model.PagedResult;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.GroupMemberResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.GroupEntity;
import io.gravitee.rest.api.model.GroupMemberEntity;
import io.gravitee.rest.api.model.MemberEntity;
import io.gravitee.rest.api.model.MemberRoleEntity;
import io.gravitee.rest.api.model.MembershipMemberType;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.RoleEntity;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.alert.ApplicationAlertEventType;
import io.gravitee.rest.api.model.alert.ApplicationAlertMembershipEvent;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.model.permissions.SystemRole;
import io.gravitee.rest.api.service.GroupService;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.NotifierService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.GroupInvitationForbiddenException;
import io.gravitee.rest.api.service.exceptions.GroupMembersLimitationExceededException;
import io.gravitee.rest.api.service.notification.PortalHook;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Tag(name="Group Memberships")
public class GroupMembersResource
extends AbstractResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private GroupService groupService;
    @Inject
    private UserService userService;
    @Inject
    private NotifierService notifierService;
    @Inject
    private EventManager eventManager;
    @PathParam(value="group")
    @Parameter(name="group", hidden=true)
    private String group;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="List group members")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of group's members", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=GroupMemberEntity.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_GROUP, acls={RolePermissionAction.READ}), @Permission(value=RolePermission.GROUP_MEMBER, acls={RolePermissionAction.READ})})
    public List<GroupMemberEntity> getGroupMembers() {
        return new ArrayList<GroupMemberEntity>(this.getGroupMembers(null).getData());
    }

    @GET
    @Path(value="_paged")
    @Produces(value={"application/json"})
    @Operation(summary="List group members with pagination")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of group's members", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=GroupMemberEntity.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_GROUP, acls={RolePermissionAction.READ}), @Permission(value=RolePermission.GROUP_MEMBER, acls={RolePermissionAction.READ})})
    public PagedResult<GroupMemberEntity> getGroupMembers(@Valid @BeanParam Pageable pageable) {
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        this.groupService.findById(executionContext, this.group);
        io.gravitee.rest.api.model.common.Pageable commonPageable = null;
        if (pageable != null) {
            commonPageable = pageable.toPageable();
        }
        Page membersPage = this.membershipService.getMembersByReference(executionContext, MembershipReferenceType.GROUP, this.group, commonPageable);
        Map<String, List<MemberEntity>> members = membersPage.getContent().stream().filter(Objects::nonNull).collect(Collectors.groupingBy(MemberEntity::getId));
        List groupMemberEntities = members.keySet().stream().map(id -> new GroupMemberEntity((MemberEntity)((List)members.get(id)).get(0))).sorted(Comparator.comparing(GroupMemberEntity::getId)).collect(Collectors.toList());
        return new PagedResult<GroupMemberEntity>(groupMemberEntities, membersPage.getPageNumber(), (int)membersPage.getPageElements(), (int)membersPage.getTotalElements());
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Operation(summary="Add or update a group member")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Member has been added"), @ApiResponse(responseCode="200", description="Member has been updated"), @ApiResponse(responseCode="400", description="Membership is not valid"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_GROUP, acls={RolePermissionAction.CREATE}), @Permission(value=RolePermission.ENVIRONMENT_GROUP, acls={RolePermissionAction.UPDATE}), @Permission(value=RolePermission.GROUP_MEMBER, acls={RolePermissionAction.CREATE}), @Permission(value=RolePermission.GROUP_MEMBER, acls={RolePermissionAction.UPDATE})})
    public Response addOrUpdateGroupMember(@Valid @NotNull List<GroupMembership> memberships) {
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        GroupEntity groupEntity = this.groupService.findById(executionContext, this.group);
        boolean hasPermission = this.permissionService.hasPermission(executionContext, RolePermission.ENVIRONMENT_GROUP, GraviteeContext.getCurrentEnvironment(), new RolePermissionAction[]{RolePermissionAction.CREATE, RolePermissionAction.UPDATE, RolePermissionAction.DELETE});
        if (!hasPermission) {
            if (groupEntity.getMaxInvitation() != null) {
                Set members = this.membershipService.getMembersByReference(executionContext, MembershipReferenceType.GROUP, this.group);
                long membershipsToAddSize = memberships.stream().map(GroupMembership::getId).filter(s -> {
                    List membershipIdsToSave = members.stream().map(MemberEntity::getId).collect(Collectors.toList());
                    return !membershipIdsToSave.contains(s);
                }).count();
                if ((long)this.groupService.getNumberOfMembers(executionContext, this.group) + membershipsToAddSize > (long)groupEntity.getMaxInvitation().intValue()) {
                    throw new GroupMembersLimitationExceededException(groupEntity.getMaxInvitation().intValue());
                }
            }
            if (!groupEntity.isSystemInvitation()) {
                throw new GroupInvitationForbiddenException(GroupInvitationForbiddenException.Type.SYSTEM, this.group);
            }
        }
        for (GroupMembership membership : memberships) {
            RoleEntity groupRoleEntity;
            RoleEntity applicationRoleEntity;
            RoleEntity previousApiRole = null;
            RoleEntity previousApplicationRole = null;
            RoleEntity previousGroupRole = null;
            if (membership.getId() != null) {
                Set userRoles = this.membershipService.getRoles(MembershipReferenceType.GROUP, this.group, MembershipMemberType.USER, membership.getId());
                for (RoleEntity role : userRoles) {
                    switch (role.getScope()) {
                        case API: {
                            previousApiRole = role;
                            break;
                        }
                        case APPLICATION: {
                            previousApplicationRole = role;
                            break;
                        }
                        case GROUP: {
                            previousGroupRole = role;
                            break;
                        }
                    }
                }
            }
            if (membership.getRoles() == null || membership.getRoles().isEmpty()) continue;
            HashMap roleEntities = new HashMap();
            for (MemberRoleEntity item : membership.getRoles()) {
                this.roleService.findByScopeAndName(item.getRoleScope(), item.getRoleName(), GraviteeContext.getCurrentOrganization()).ifPresent(roleEntity -> roleEntities.put(item.getRoleScope(), roleEntity));
            }
            MemberEntity updatedMembership = null;
            RoleEntity apiRoleEntity = (RoleEntity)roleEntities.get(RoleScope.API);
            if (apiRoleEntity != null && !apiRoleEntity.equals((Object)previousApiRole)) {
                String roleName = apiRoleEntity.getName();
                if (!hasPermission && groupEntity.isLockApiRole()) {
                    if (groupEntity.getRoles() != null && !groupEntity.getRoles().isEmpty()) {
                        roleName = (String)groupEntity.getRoles().get(RoleScope.API);
                    } else {
                        List defaultRoles = this.roleService.findDefaultRoleByScopes(GraviteeContext.getCurrentOrganization(), new RoleScope[]{RoleScope.API});
                        if (defaultRoles != null && !defaultRoles.isEmpty()) {
                            roleName = ((RoleEntity)defaultRoles.get(0)).getName();
                        }
                    }
                }
                updatedMembership = this.membershipService.addRoleToMemberOnReference(executionContext, new MembershipService.MembershipReference(MembershipReferenceType.GROUP, this.group), new MembershipService.MembershipMember(membership.getId(), membership.getReference(), MembershipMemberType.USER), new MembershipService.MembershipRole(RoleScope.API, roleName));
                if (previousApiRole != null) {
                    this.membershipService.removeRole(MembershipReferenceType.GROUP, this.group, MembershipMemberType.USER, updatedMembership.getId(), previousApiRole.getId());
                }
                if (previousApiRole != null && previousApiRole.getName().equals(SystemRole.PRIMARY_OWNER.name())) {
                    this.groupService.updateApiPrimaryOwner(this.group, null);
                } else if (roleName.equals(SystemRole.PRIMARY_OWNER.name())) {
                    this.groupService.updateApiPrimaryOwner(this.group, updatedMembership.getId());
                }
            }
            if ((applicationRoleEntity = (RoleEntity)roleEntities.get(RoleScope.APPLICATION)) != null && !applicationRoleEntity.equals((Object)previousApplicationRole)) {
                String roleName = applicationRoleEntity.getName();
                if (!hasPermission && groupEntity.isLockApplicationRole()) {
                    if (groupEntity.getRoles() != null && !groupEntity.getRoles().isEmpty()) {
                        roleName = (String)groupEntity.getRoles().get(RoleScope.APPLICATION);
                    } else {
                        List defaultRoles = this.roleService.findDefaultRoleByScopes(GraviteeContext.getCurrentOrganization(), new RoleScope[]{RoleScope.APPLICATION});
                        if (defaultRoles != null && !defaultRoles.isEmpty()) {
                            roleName = ((RoleEntity)defaultRoles.get(0)).getName();
                        }
                    }
                }
                updatedMembership = this.membershipService.addRoleToMemberOnReference(executionContext, new MembershipService.MembershipReference(MembershipReferenceType.GROUP, this.group), new MembershipService.MembershipMember(membership.getId(), membership.getReference(), MembershipMemberType.USER), new MembershipService.MembershipRole(RoleScope.APPLICATION, roleName));
                if (previousApplicationRole != null) {
                    this.membershipService.removeRole(MembershipReferenceType.GROUP, this.group, MembershipMemberType.USER, updatedMembership.getId(), previousApplicationRole.getId());
                }
            }
            if ((groupRoleEntity = (RoleEntity)roleEntities.get(RoleScope.GROUP)) != null && !groupRoleEntity.equals((Object)previousGroupRole)) {
                updatedMembership = this.membershipService.addRoleToMemberOnReference(executionContext, new MembershipService.MembershipReference(MembershipReferenceType.GROUP, this.group), new MembershipService.MembershipMember(membership.getId(), membership.getReference(), MembershipMemberType.USER), new MembershipService.MembershipRole(RoleScope.GROUP, groupRoleEntity.getName()));
                if (previousGroupRole != null) {
                    this.membershipService.removeRole(MembershipReferenceType.GROUP, this.group, MembershipMemberType.USER, updatedMembership.getId(), previousGroupRole.getId());
                }
            }
            if (apiRoleEntity == null && previousApiRole != null) {
                this.membershipService.removeRole(MembershipReferenceType.GROUP, this.group, MembershipMemberType.USER, membership.getId(), previousApiRole.getId());
            }
            if (applicationRoleEntity == null && previousApplicationRole != null) {
                this.membershipService.removeRole(MembershipReferenceType.GROUP, this.group, MembershipMemberType.USER, membership.getId(), previousApplicationRole.getId());
            }
            if (groupRoleEntity == null && previousGroupRole != null) {
                this.membershipService.removeRole(MembershipReferenceType.GROUP, this.group, MembershipMemberType.USER, membership.getId(), previousGroupRole.getId());
            }
            if (previousApiRole != null || previousApplicationRole != null || previousGroupRole != null || updatedMembership == null) continue;
            UserEntity userEntity = this.userService.findById(executionContext, updatedMembership.getId());
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("group", groupEntity);
            params.put("user", userEntity);
            this.notifierService.trigger(executionContext, PortalHook.GROUP_INVITATION, params);
        }
        this.eventManager.publishEvent((Enum)ApplicationAlertEventType.APPLICATION_MEMBERSHIP_UPDATE, (Object)new ApplicationAlertMembershipEvent(executionContext.getOrganizationId(), Collections.emptySet(), Collections.singleton(this.group)));
        return Response.ok().build();
    }

    @Path(value="{member}")
    public GroupMemberResource groupMemberResource() {
        return (GroupMemberResource)this.resourceContext.getResource(GroupMemberResource.class);
    }
}

