/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.repository.management.model.DashboardReferenceType;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.DashboardEntity;
import io.gravitee.rest.api.model.NewDashboardEntity;
import io.gravitee.rest.api.model.UpdateDashboardEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.DashboardService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.ForbiddenAccessException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Tag(name="Dashboards")
public class DashboardsResource
extends AbstractResource {
    @Inject
    private DashboardService dashboardService;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve the list of platform dashboards")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of platform dashboards", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=DashboardEntity.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public List<DashboardEntity> getDashboards(@QueryParam(value="reference_type") DashboardReferenceType referenceType) {
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        if (!(this.hasPermission(executionContext, RolePermission.ENVIRONMENT_DASHBOARD, executionContext.getEnvironmentId(), RolePermissionAction.READ) || this.hasPermission(executionContext, RolePermission.ENVIRONMENT_API, executionContext.getEnvironmentId(), RolePermissionAction.READ) || this.canReadAPIConfiguration() || DashboardReferenceType.HOME.equals((Object)referenceType))) {
            throw new ForbiddenAccessException();
        }
        if (referenceType == null) {
            return this.dashboardService.findAll();
        }
        return this.dashboardService.findByReferenceType(referenceType);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create a platform dashboard", description="User must have the MANAGEMENT_DASHBOARD[CREATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Dashboard successfully created", content={@Content(mediaType="application/json", schema=@Schema(implementation=DashboardEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_DASHBOARD, acls={RolePermissionAction.CREATE})})
    public DashboardEntity createDashboard(@Valid @NotNull NewDashboardEntity dashboard) {
        return this.dashboardService.create(GraviteeContext.getExecutionContext(), dashboard);
    }

    @GET
    @Path(value="{dashboardId}")
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve a platform dashboard", description="User must have the MANAGEMENT_DASHBOARD[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Platform dashboard", content={@Content(mediaType="application/json", schema=@Schema(implementation=DashboardEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_DASHBOARD, acls={RolePermissionAction.READ})})
    public DashboardEntity getDashboard(@PathParam(value="dashboardId") String dashboardId) {
        return this.dashboardService.findById(dashboardId);
    }

    @Path(value="{dashboardId}")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update a platform dashboard", description="User must have the MANAGEMENT_DASHBOARD[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Updated dashboard", content={@Content(mediaType="application/json", schema=@Schema(implementation=DashboardEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_DASHBOARD, acls={RolePermissionAction.UPDATE})})
    public DashboardEntity updateDashboard(@PathParam(value="dashboardId") String dashboardId, @Valid @NotNull UpdateDashboardEntity dashboard) {
        dashboard.setId(dashboardId);
        return this.dashboardService.update(GraviteeContext.getExecutionContext(), dashboard);
    }

    @Path(value="{dashboardId}")
    @DELETE
    @Consumes(value={"application/json"})
    @Operation(summary="Delete a platform dashboard", description="User must have the MANAGEMENT_DASHBOARD[DELETE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Dashboard successfully deleted"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_DASHBOARD, acls={RolePermissionAction.DELETE})})
    public void deleteDashboard(@PathParam(value="dashboardId") String dashboardId) {
        this.dashboardService.delete(GraviteeContext.getExecutionContext(), dashboardId);
    }
}

