/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.organization;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.organization.RoleResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.NewRoleEntity;
import io.gravitee.rest.api.model.RoleEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.service.RoleService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;

@Tag(name="Roles")
public class RoleScopeResource
extends AbstractResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private RoleService roleService;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="List of roles", description="User must have the MANAGEMENT_ROLE[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Role successfully removed", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=RoleEntity.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_ROLE, acls={RolePermissionAction.READ})})
    public List<RoleEntity> getRoles(@PathParam(value="scope") RoleScope scope) {
        return this.roleService.findByScope(scope, GraviteeContext.getCurrentOrganization());
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create a role", description="User must have the MANAGEMENT_ROLE[CREATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Role successfully created", content={@Content(mediaType="application/json", schema=@Schema(implementation=RoleEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_ROLE, acls={RolePermissionAction.CREATE})})
    public RoleEntity createRole(@PathParam(value="scope") RoleScope scope, @Valid @NotNull NewRoleEntity role) {
        return this.roleService.create(GraviteeContext.getExecutionContext(), role);
    }

    @Path(value="{role}")
    public RoleResource getRoleResource() {
        return (RoleResource)this.resourceContext.getResource(RoleResource.class);
    }
}

