/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.MediaEntity;
import io.gravitee.rest.api.model.PageEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.MediaService;
import io.gravitee.rest.api.service.PageService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.UploadUnauthorized;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;

@Tag(name="Portal Media")
public class PortalPageMediaResource
extends AbstractResource {
    @Inject
    private MediaService mediaService;
    @Inject
    private PageService pageService;
    @PathParam(value="page")
    @Parameter(name="page", required=true)
    private String page;

    @POST
    @Operation(summary="Attach a media to a portal page ", description="User must have the ENVIRONMENT_DOCUMENTATION[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Media successfully added", content={@Content(mediaType="application/json", schema=@Schema(implementation=MediaEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_DOCUMENTATION, acls={RolePermissionAction.UPDATE})})
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    public Response attachPortalPageMedia(@Context HttpServletRequest request, @FormDataParam(value="file") InputStream uploadedInputStream, @FormDataParam(value="file") FormDataContentDisposition fileDetail, @FormDataParam(value="file") FormDataBodyPart body, @FormDataParam(value="fileName") String fileName) throws IOException {
        if ((long)request.getContentLength() > this.mediaService.getMediaMaxSize(GraviteeContext.getExecutionContext())) {
            throw new UploadUnauthorized("Max size is " + this.mediaService.getMediaMaxSize(GraviteeContext.getExecutionContext()) + "bytes. Actual size is " + request.getContentLength() + "bytes.");
        }
        String originalFileName = fileDetail.getFileName();
        MediaEntity mediaEntity = new MediaEntity();
        mediaEntity.setSize(fileDetail.getSize());
        mediaEntity.setType(body.getMediaType().getType());
        mediaEntity.setSubType(body.getMediaType().getSubtype());
        mediaEntity.setData(IOUtils.toByteArray((InputStream)uploadedInputStream));
        mediaEntity.setFileName(originalFileName);
        String mediaId = this.mediaService.savePortalMedia(mediaEntity);
        this.pageService.attachMedia(this.page, mediaId, fileName == null ? originalFileName : fileName).ifPresent(pageEntity -> pageEntity.getAttachedMedia().stream().filter(media -> media.getMediaHash().equals(mediaId)).findFirst().ifPresent(createdMedia -> {
            mediaEntity.setUploadDate(createdMedia.getAttachedAt());
            mediaEntity.setHash(createdMedia.getMediaHash());
        }));
        mediaEntity.setData(null);
        URI location = URI.create(this.uriInfo.getPath());
        return Response.created((URI)location).entity((Object)mediaEntity).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve all media for a Portal page", description="User must have the ENVIRONMENT_DOCUMENTATION[READ] permission to use this service")
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_DOCUMENTATION, acls={RolePermissionAction.READ})})
    public Response getPortalPageMedia() {
        PageEntity currentPage = this.pageService.findById(this.page);
        List pageMedia = this.mediaService.findAllWithoutContent(currentPage.getAttachedMedia());
        if (pageMedia != null && !pageMedia.isEmpty()) {
            return Response.ok((Object)pageMedia).build();
        }
        return Response.noContent().build();
    }
}

