/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractCategoryResource;
import io.gravitee.rest.api.management.rest.resource.CategoryResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.CategoryEntity;
import io.gravitee.rest.api.model.NewCategoryEntity;
import io.gravitee.rest.api.model.UpdateCategoryEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.CategoryService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;

@Tag(name="Categories")
public class CategoriesResource
extends AbstractCategoryResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private CategoryService categoryService;
    private static final String INCLUDE_TOTAL_APIS = "total-apis";

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve list of categories")
    public List<CategoryEntity> getCategories(@QueryParam(value="include") List<String> include) {
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        boolean hasAllPermissions = this.hasPermission(executionContext, RolePermission.ENVIRONMENT_CATEGORY, RolePermissionAction.UPDATE, RolePermissionAction.CREATE, RolePermissionAction.DELETE);
        return this.categoryService.findAll(GraviteeContext.getCurrentEnvironment()).stream().filter(c -> hasAllPermissions || !c.isHidden()).sorted(Comparator.comparingInt(CategoryEntity::getOrder)).map(c -> this.setPictures((CategoryEntity)c, true)).map(categoryEntity -> {
            if (include.contains(INCLUDE_TOTAL_APIS)) {
                categoryEntity.setTotalApis(this.apiService.countByCategoryForUser(executionContext, categoryEntity.getId(), this.getAuthenticatedUser()));
            }
            return categoryEntity;
        }).collect(Collectors.toList());
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create a category", description="User must have the PORTAL_CATEGORY[CREATE] permission to use this service")
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_CATEGORY, acls={RolePermissionAction.CREATE})})
    public CategoryEntity createCategory(@Valid @NotNull NewCategoryEntity category) {
        return this.categoryService.create(GraviteeContext.getExecutionContext(), category);
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update an existing category", description="User must have the PORTAL_CATEGORY[UPDATE] permission to use this service")
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_CATEGORY, acls={RolePermissionAction.UPDATE})})
    public List<CategoryEntity> updateCategories(@Valid @NotNull List<UpdateCategoryEntity> categories) {
        return this.categoryService.update(GraviteeContext.getExecutionContext(), categories);
    }

    @Path(value="{categoryId}")
    public CategoryResource getCategoryResource() {
        return (CategoryResource)this.resourceContext.getResource(CategoryResource.class);
    }
}

