/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractApiKeyResource;
import io.gravitee.rest.api.management.rest.resource.ApplicationSubscriptionApiKeyResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.ApiKeyEntity;
import io.gravitee.rest.api.model.SubscriptionEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.ApiKeyService;
import io.gravitee.rest.api.service.SubscriptionService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.net.URI;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Tag(name="API Keys")
public class ApplicationSubscriptionApiKeysResource
extends AbstractApiKeyResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private ApiKeyService apiKeyService;
    @Inject
    private SubscriptionService subscriptionService;
    @PathParam(value="application")
    @Parameter(name="application", hidden=true)
    private String application;
    @PathParam(value="subscription")
    @Parameter(name="subscription", hidden=true)
    private String subscription;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="List all API Keys for a subscription", description="User must have the READ permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of API Keys for a subscription", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=ApiKeyEntity.class), uniqueItems=true))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_SUBSCRIPTION, acls={RolePermissionAction.READ})})
    public List<ApiKeyEntity> getApiKeysForApplicationSubscription() {
        return this.apiKeyService.findBySubscription(GraviteeContext.getExecutionContext(), this.subscription);
    }

    @POST
    @Path(value="/_renew")
    @Produces(value={"application/json"})
    @Operation(summary="Renew an API key", description="User must have the MANAGE_API_KEYS permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="A new API Key", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiKeyEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_SUBSCRIPTION, acls={RolePermissionAction.UPDATE})})
    public Response renewApiKeyForApplicationSubscription() {
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        this.checkApplicationDoesntUseSharedApiKey(executionContext, this.application);
        SubscriptionEntity subscriptionEntity = this.subscriptionService.findById(this.subscription);
        ApiKeyEntity apiKeyEntity = this.apiKeyService.renew(executionContext, subscriptionEntity);
        URI location = URI.create(this.uriInfo.getPath().replace("_renew", apiKeyEntity.getId()));
        return Response.created((URI)location).entity((Object)apiKeyEntity).build();
    }

    @Path(value="{apikey}")
    public ApplicationSubscriptionApiKeyResource getApplicationSubscriptionApiKeyResource() {
        return (ApplicationSubscriptionApiKeyResource)this.resourceContext.getResource(ApplicationSubscriptionApiKeyResource.class);
    }
}

