/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.model.ApiMembership;
import io.gravitee.rest.api.management.rest.model.TransferOwnership;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.MemberEntity;
import io.gravitee.rest.api.model.MembershipListItem;
import io.gravitee.rest.api.model.MembershipMemberType;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.permissions.ApiPermission;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.model.permissions.SystemRole;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.SinglePrimaryOwnerException;
import io.gravitee.rest.api.service.exceptions.UserNotFoundException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Tag(name="API Memberships")
public class ApiMembersResource
extends AbstractResource {
    @Inject
    private UserService userService;
    @PathParam(value="api")
    @Parameter(name="api", hidden=true)
    private String api;

    @GET
    @Path(value="/permissions")
    @Produces(value={"application/json"})
    @Operation(summary="Get API members", description="User must have the MANAGE_MEMBERS permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="API member's permissions", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=MemberEntity.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getApiMembersPermissions() {
        ApiEntity apiEntity = this.apiService.findById(GraviteeContext.getExecutionContext(), this.api);
        Map<String, char[]> permissions = new HashMap();
        if (this.isAuthenticated()) {
            String userId = this.getAuthenticatedUser();
            if (this.isAdmin()) {
                char[] rights = new char[]{RolePermissionAction.CREATE.getId(), RolePermissionAction.READ.getId(), RolePermissionAction.UPDATE.getId(), RolePermissionAction.DELETE.getId()};
                for (ApiPermission perm : ApiPermission.values()) {
                    permissions.put(perm.getName(), rights);
                }
            } else {
                permissions = this.membershipService.getUserMemberPermissions(GraviteeContext.getExecutionContext(), apiEntity, userId);
            }
        }
        return Response.ok(permissions).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="List API members", description="User must have the MANAGE_MEMBERS permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of API's members", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=MembershipListItem.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_MEMBER, acls={RolePermissionAction.READ})})
    public List<MembershipListItem> getApiMembers() {
        this.apiService.findById(GraviteeContext.getExecutionContext(), this.api);
        return this.membershipService.getMembersByReference(GraviteeContext.getExecutionContext(), MembershipReferenceType.API, this.api).stream().filter(memberEntity -> memberEntity.getType() == MembershipMemberType.USER).map(MembershipListItem::new).sorted(Comparator.comparing(MembershipListItem::getId)).collect(Collectors.toList());
    }

    @POST
    @Operation(summary="Add or update an API member", description="User must have the MANAGE_MEMBERS permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Member has been added or updated successfully"), @ApiResponse(responseCode="400", description="Membership parameter is not valid"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_MEMBER, acls={RolePermissionAction.CREATE}), @Permission(value=RolePermission.API_MEMBER, acls={RolePermissionAction.UPDATE})})
    public Response addOrUpdateApiMember(@Valid @NotNull ApiMembership apiMembership) {
        MemberEntity userMember;
        if (SystemRole.PRIMARY_OWNER.name().equals(apiMembership.getRole())) {
            throw new SinglePrimaryOwnerException(RoleScope.API);
        }
        this.apiService.findById(GraviteeContext.getExecutionContext(), this.api);
        MembershipService.MembershipReference reference = new MembershipService.MembershipReference(MembershipReferenceType.API, this.api);
        MembershipService.MembershipMember member = new MembershipService.MembershipMember(apiMembership.getId(), apiMembership.getReference(), MembershipMemberType.USER);
        MembershipService.MembershipRole role = new MembershipService.MembershipRole(RoleScope.API, apiMembership.getRole());
        MemberEntity membership = null;
        if (apiMembership.getId() != null && (userMember = this.membershipService.getUserMember(GraviteeContext.getExecutionContext(), MembershipReferenceType.API, this.api, apiMembership.getId())) != null && userMember.getRoles() != null && !userMember.getRoles().isEmpty()) {
            membership = this.membershipService.updateRoleToMemberOnReference(GraviteeContext.getExecutionContext(), reference, member, role);
        }
        if (membership == null) {
            this.membershipService.addRoleToMemberOnReference(GraviteeContext.getExecutionContext(), reference, member, role);
        }
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    @POST
    @Path(value="transfer_ownership")
    @Operation(summary="Transfer the ownership of the API", description="User must have the TRANSFER_OWNERSHIP permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ownership has been transferred successfully"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_MEMBER, acls={RolePermissionAction.UPDATE})})
    public Response transferApiMemberOwnership(@Valid @NotNull TransferOwnership transferOwnership) {
        ArrayList newRoles = new ArrayList();
        if (transferOwnership.getPoRole() != null) {
            this.roleService.findByScopeAndName(RoleScope.API, transferOwnership.getPoRole(), GraviteeContext.getCurrentOrganization()).ifPresent(newRoles::add);
        }
        this.apiService.findById(GraviteeContext.getExecutionContext(), this.api);
        this.membershipService.transferApiOwnership(GraviteeContext.getExecutionContext(), this.api, new MembershipService.MembershipMember(transferOwnership.getId(), transferOwnership.getReference(), transferOwnership.getType()), newRoles);
        return Response.ok().build();
    }

    @DELETE
    @Operation(summary="Remove an API member", description="User must have the MANAGE_MEMBERS permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Member has been removed successfully"), @ApiResponse(responseCode="400", description="User does not exist"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_MEMBER, acls={RolePermissionAction.DELETE})})
    public Response deleteApiMember(@Parameter(name="user", required=true) @NotNull @QueryParam(value="user") String userId) {
        this.apiService.findById(GraviteeContext.getExecutionContext(), this.api);
        try {
            this.userService.findById(GraviteeContext.getExecutionContext(), userId);
        }
        catch (UserNotFoundException unfe) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)unfe.getMessage()).build();
        }
        this.membershipService.deleteReferenceMember(GraviteeContext.getExecutionContext(), MembershipReferenceType.API, this.api, MembershipMemberType.USER, userId);
        return Response.ok().build();
    }
}

