/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.PortalPageMediaResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.management.rest.utils.HttpHeadersUtil;
import io.gravitee.rest.api.model.ImportPageEntity;
import io.gravitee.rest.api.model.NewPageEntity;
import io.gravitee.rest.api.model.PageEntity;
import io.gravitee.rest.api.model.PageType;
import io.gravitee.rest.api.model.UpdatePageEntity;
import io.gravitee.rest.api.model.documentation.PageQuery;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.AccessControlService;
import io.gravitee.rest.api.service.ConfigService;
import io.gravitee.rest.api.service.PageService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.PageSystemFolderActionException;
import io.gravitee.rest.api.service.exceptions.UnauthorizedAccessException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Tag(name="Portal Pages")
public class PortalPagesResource
extends AbstractResource {
    @Inject
    private PageService pageService;
    @Inject
    private AccessControlService accessControlService;
    @Inject
    private ConfigService configService;
    @Context
    private ResourceContext resourceContext;

    @GET
    @Path(value="/{page}")
    @Produces(value={"application/json"})
    @Operation(summary="Get a page", description="Every users can use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Page", content={@Content(mediaType="application/json", schema=@Schema(implementation=PageEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public PageEntity getPortalPage(@HeaderParam(value="Accept-Language") String acceptLang, @PathParam(value="page") String page, @QueryParam(value="portal") boolean portal, @QueryParam(value="translated") boolean translated) {
        String acceptedLocale = HttpHeadersUtil.getFirstAcceptedLocaleName(acceptLang);
        PageEntity pageEntity = this.pageService.findById(page, translated ? acceptedLocale : null);
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        if (this.isDisplayable(executionContext, pageEntity)) {
            if (!this.isAuthenticated() && pageEntity.getMetadata() != null) {
                pageEntity.getMetadata().clear();
            }
            if (portal) {
                this.pageService.transformWithTemplate(executionContext, pageEntity, null);
            }
            return pageEntity;
        }
        throw new UnauthorizedAccessException();
    }

    @GET
    @Path(value="/{page}/content")
    @Produces(value={"text/plain"})
    @Operation(summary="Get the page's content", description="Every users can use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Page's content", content={@Content(mediaType="text/plain", schema=@Schema(type="string"))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getPortalPageContent(@PathParam(value="page") String page) {
        PageEntity pageEntity = this.pageService.findById(page);
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        if (this.isDisplayable(executionContext, pageEntity)) {
            this.pageService.transformSwagger(executionContext, pageEntity);
            return Response.ok((Object)pageEntity.getContent(), (String)pageEntity.getContentType()).build();
        }
        throw new UnauthorizedAccessException();
    }

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="List pages", description="Every users can use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of pages", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=PageEntity.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public List<PageEntity> getPortalPages(@HeaderParam(value="Accept-Language") String acceptLang, @QueryParam(value="homepage") Boolean homepage, @QueryParam(value="published") Boolean published, @QueryParam(value="type") PageType type, @QueryParam(value="parent") String parent, @QueryParam(value="name") String name, @QueryParam(value="root") Boolean rootParent, @QueryParam(value="translated") boolean translated) {
        String acceptedLocale = HttpHeadersUtil.getFirstAcceptedLocaleName(acceptLang);
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        return this.pageService.search(executionContext.getEnvironmentId(), new PageQuery.Builder().homepage(homepage).published(published).type(type).parent(parent).name(name).rootParent(rootParent).build(), translated ? acceptedLocale : null).stream().filter(pageEntity -> this.isDisplayable(executionContext, (PageEntity)pageEntity)).collect(Collectors.toList());
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create a page", description="User must have the ENVIRONMENT_DOCUMENTATION[CREATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Page successfully created", content={@Content(mediaType="application/json", schema=@Schema(implementation=PageEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_DOCUMENTATION, acls={RolePermissionAction.CREATE})})
    public Response createPortalPage(@Parameter(name="page", required=true) @Valid @NotNull NewPageEntity newPageEntity) {
        if (newPageEntity.getType().equals((Object)PageType.SYSTEM_FOLDER)) {
            throw new PageSystemFolderActionException("Create");
        }
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        int order = this.pageService.findMaxPortalPageOrder(executionContext.getEnvironmentId()) + 1;
        newPageEntity.setOrder(order);
        newPageEntity.setLastContributor(this.getAuthenticatedUser());
        PageEntity newPage = this.pageService.createPage(executionContext, newPageEntity);
        if (newPage != null) {
            return Response.created((URI)this.getLocationHeader(newPage.getId())).entity((Object)newPage).build();
        }
        return Response.serverError().build();
    }

    @PUT
    @Path(value="/{page}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update a page", description="User must have the ENVIRONMENT_DOCUMENTATION[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Page successfully updated", content={@Content(mediaType="application/json", schema=@Schema(implementation=PageEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_DOCUMENTATION, acls={RolePermissionAction.UPDATE})})
    public PageEntity updatePortalPage(@PathParam(value="page") String page, @Parameter(name="page", required=true) @Valid @NotNull UpdatePageEntity updatePageEntity) {
        PageEntity existingPage = this.pageService.findById(page);
        if (existingPage.getType().equals(PageType.SYSTEM_FOLDER.name())) {
            throw new PageSystemFolderActionException("Update");
        }
        updatePageEntity.setLastContributor(this.getAuthenticatedUser());
        return this.pageService.update(GraviteeContext.getExecutionContext(), page, updatePageEntity);
    }

    @PUT
    @Path(value="/{page}/content")
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    @Operation(summary="Update a page content", description="User must have the PORTAL_DOCUMENTATION[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Page content successfully updated", content={@Content(mediaType="text/plain", schema=@Schema(type="string"))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_DOCUMENTATION, acls={RolePermissionAction.UPDATE})})
    public String updatePageContent(@PathParam(value="page") String page, @Parameter(name="content", required=true) @Valid @NotNull String content) {
        this.pageService.findById(page);
        UpdatePageEntity updatePageEntity = new UpdatePageEntity();
        updatePageEntity.setContent(content);
        PageEntity update = this.pageService.update(GraviteeContext.getExecutionContext(), page, updatePageEntity, true);
        return update.getContent();
    }

    @PATCH
    @Path(value="/{page}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update a page", description="User must have the ENVIRONMENT_DOCUMENTATION[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Page successfully updated", content={@Content(mediaType="application/json", schema=@Schema(implementation=PageEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_DOCUMENTATION, acls={RolePermissionAction.UPDATE})})
    public PageEntity partialUpdatePortalPage(@PathParam(value="page") String page, @Parameter(name="page", required=true) @NotNull UpdatePageEntity updatePageEntity) {
        PageEntity existingPage = this.pageService.findById(page);
        if (existingPage.getType().equals(PageType.SYSTEM_FOLDER.name())) {
            throw new PageSystemFolderActionException("Update");
        }
        updatePageEntity.setLastContributor(this.getAuthenticatedUser());
        return this.pageService.update(GraviteeContext.getExecutionContext(), page, updatePageEntity, true);
    }

    @POST
    @Path(value="/{page}/_fetch")
    @Produces(value={"application/json"})
    @Operation(summary="Refresh page by calling the associated fetcher", description="User must have the ENVIRONMENT_DOCUMENTATION[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Page successfully refreshed", content={@Content(mediaType="application/json", schema=@Schema(implementation=PageEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_DOCUMENTATION, acls={RolePermissionAction.UPDATE})})
    public PageEntity fetchPortalPage(@PathParam(value="page") String page) {
        this.pageService.findById(page);
        String contributor = this.getAuthenticatedUser();
        return this.pageService.fetch(GraviteeContext.getExecutionContext(), page, contributor);
    }

    @POST
    @Path(value="/_fetch")
    @Produces(value={"application/json"})
    @Operation(summary="Refresh all pages by calling their associated fetcher", description="User must have the ENVIRONMENT_DOCUMENTATION[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Pages successfully refreshed", content={@Content(mediaType="application/json", schema=@Schema(implementation=PageEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_DOCUMENTATION, acls={RolePermissionAction.UPDATE})})
    public Response fetchAllPortalPages() {
        String contributor = this.getAuthenticatedUser();
        this.pageService.fetchAll(GraviteeContext.getExecutionContext(), new PageQuery.Builder().build(), contributor);
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="/{page}")
    @Operation(summary="Delete a page", description="User must have the ENVIRONMENT_DOCUMENTATION[DELETE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Page successfully deleted"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_DOCUMENTATION, acls={RolePermissionAction.DELETE})})
    public void deletePortalPage(@PathParam(value="page") String page) {
        PageEntity existingPage = this.pageService.findById(page);
        if (existingPage.getType().equals(PageType.SYSTEM_FOLDER.name())) {
            throw new PageSystemFolderActionException("Delete");
        }
        this.pageService.delete(GraviteeContext.getExecutionContext(), page);
    }

    @POST
    @Path(value="/_import")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Import pages", description="User must have the ENVIRONMENT_DOCUMENTATION[CREATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Page successfully created", content={@Content(mediaType="application/json", schema=@Schema(implementation=PageEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_DOCUMENTATION, acls={RolePermissionAction.CREATE})})
    public List<PageEntity> importPortalPageFromFiles(@Parameter(name="page", required=true) @Valid @NotNull ImportPageEntity importPageEntity) {
        importPageEntity.setLastContributor(this.getAuthenticatedUser());
        return this.pageService.importFiles(GraviteeContext.getExecutionContext(), importPageEntity);
    }

    @PUT
    @Path(value="/_import")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Import pages", description="User must have the ENVIRONMENT_DOCUMENTATION[CREATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Page successfully updated", content={@Content(mediaType="application/json", schema=@Schema(implementation=PageEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_DOCUMENTATION, acls={RolePermissionAction.CREATE})})
    public List<PageEntity> updateImportedPortalPageFromFiles(@Parameter(name="page", required=true) @Valid @NotNull ImportPageEntity importPageEntity) {
        importPageEntity.setLastContributor(this.getAuthenticatedUser());
        return this.pageService.importFiles(GraviteeContext.getExecutionContext(), importPageEntity);
    }

    private boolean isDisplayable(ExecutionContext executionContext, PageEntity pageEntity) {
        if (!this.isAuthenticated() && this.configService.portalLoginForced(executionContext)) {
            return false;
        }
        if (this.isAuthenticated() && this.isAdmin()) {
            return true;
        }
        return this.accessControlService.canAccessPageFromPortal(executionContext, pageEntity);
    }

    @Path(value="/{page}/media")
    public PortalPageMediaResource getPortalPageMediaResource() {
        return (PortalPageMediaResource)this.resourceContext.getResource(PortalPageMediaResource.class);
    }
}

