/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.repository.management.model.NotificationReferenceType;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.notification.GenericNotificationConfigEntity;
import io.gravitee.rest.api.model.notification.NotificationConfigType;
import io.gravitee.rest.api.model.notification.PortalNotificationConfigEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.GenericNotificationConfigService;
import io.gravitee.rest.api.service.PortalNotificationConfigService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.ForbiddenAccessException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Tag(name="Application Notifications")
public class ApplicationNotificationSettingsResource
extends AbstractResource {
    @Inject
    private PortalNotificationConfigService portalNotificationConfigService;
    @Inject
    private GenericNotificationConfigService genericNotificationConfigService;
    @PathParam(value="application")
    @Parameter(name="application", hidden=true)
    private String application;

    @GET
    @Operation(summary="Get notification settings")
    @Produces(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_NOTIFICATION, acls={RolePermissionAction.READ})})
    public List<Object> getApplicationNotificationSettings() {
        ArrayList<Object> settings = new ArrayList<Object>();
        settings.add(this.portalNotificationConfigService.findById(this.getAuthenticatedUser(), NotificationReferenceType.APPLICATION, this.application));
        if (this.hasPermission(GraviteeContext.getExecutionContext(), RolePermission.APPLICATION_NOTIFICATION, this.application, RolePermissionAction.CREATE, RolePermissionAction.UPDATE, RolePermissionAction.DELETE)) {
            settings.addAll(this.genericNotificationConfigService.findByReference(NotificationReferenceType.APPLICATION, this.application));
        }
        return settings;
    }

    @POST
    @Operation(summary="Create notification settings")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Object createApplicationNotificationSettings(GenericNotificationConfigEntity config) {
        if (!this.application.equals(config.getReferenceId()) || !NotificationReferenceType.APPLICATION.name().equals(config.getReferenceType())) {
            throw new ForbiddenAccessException();
        }
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        if (config.getConfigType().equals((Object)NotificationConfigType.GENERIC) && this.hasPermission(executionContext, RolePermission.APPLICATION_NOTIFICATION, this.application, RolePermissionAction.CREATE)) {
            return this.genericNotificationConfigService.create(config);
        }
        if (config.getConfigType().equals((Object)NotificationConfigType.PORTAL) && this.hasPermission(executionContext, RolePermission.APPLICATION_NOTIFICATION, this.application, RolePermissionAction.READ)) {
            return this.portalNotificationConfigService.save(this.convert(config));
        }
        throw new ForbiddenAccessException();
    }

    @PUT
    @Path(value="{notificationId}")
    @Operation(summary="Update generic notification settings")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_NOTIFICATION, acls={RolePermissionAction.UPDATE})})
    public GenericNotificationConfigEntity updateApplicationGeneralNotificationSettings(@PathParam(value="notificationId") String notificationId, GenericNotificationConfigEntity config) {
        if (!(this.application.equals(config.getReferenceId()) && NotificationReferenceType.APPLICATION.name().equals(config.getReferenceType()) && config.getConfigType().equals((Object)NotificationConfigType.GENERIC) && notificationId.equals(config.getId()))) {
            throw new ForbiddenAccessException();
        }
        return this.genericNotificationConfigService.update(config);
    }

    @PUT
    @Operation(summary="Update portal notification settings")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_NOTIFICATION, acls={RolePermissionAction.READ})})
    public PortalNotificationConfigEntity updateApplicationPortalNotificationSettings(PortalNotificationConfigEntity config) {
        if (!(this.application.equals(config.getReferenceId()) && NotificationReferenceType.APPLICATION.name().equals(config.getReferenceType()) && config.getConfigType().equals((Object)NotificationConfigType.PORTAL))) {
            throw new ForbiddenAccessException();
        }
        config.setUser(this.getAuthenticatedUser());
        return this.portalNotificationConfigService.save(config);
    }

    @DELETE
    @Path(value="{notificationId}")
    @Operation(summary="Delete notification settings")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_NOTIFICATION, acls={RolePermissionAction.DELETE})})
    public Response deleteApplicationNotificationSettings(@PathParam(value="notificationId") String notificationId) {
        this.genericNotificationConfigService.delete(notificationId);
        return Response.noContent().build();
    }

    private PortalNotificationConfigEntity convert(GenericNotificationConfigEntity generic) {
        PortalNotificationConfigEntity portalNotificationConfigEntity = new PortalNotificationConfigEntity();
        portalNotificationConfigEntity.setConfigType(generic.getConfigType());
        portalNotificationConfigEntity.setReferenceType(generic.getReferenceType());
        portalNotificationConfigEntity.setReferenceId(generic.getReferenceId());
        portalNotificationConfigEntity.setUser(this.getAuthenticatedUser());
        portalNotificationConfigEntity.setHooks(generic.getHooks());
        return portalNotificationConfigEntity;
    }
}

