/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.portal;

import io.gravitee.common.component.Lifecycle;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.model.RatingSummaryEntity;
import io.gravitee.rest.api.model.Visibility;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.api.ApiLifecycleState;
import io.gravitee.rest.api.model.api.ApiListItem;
import io.gravitee.rest.api.model.api.ApiQuery;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.ConfigService;
import io.gravitee.rest.api.service.RatingService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;

@Tag(name="Portal APIs")
public class PortalApisResource
extends AbstractResource {
    @Inject
    private ApiService apiService;
    @Inject
    private RatingService ratingService;
    @Context
    private ResourceContext resourceContext;
    @Inject
    private ConfigService configService;

    @POST
    @Path(value="_search")
    @Produces(value={"application/json"})
    @Operation(summary="Search for API using the search engine")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List accessible APIs for current user", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=ApiListItem.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response searchPortalApis(@Parameter(name="q", required=true) @NotNull @QueryParam(value="q") String query) {
        try {
            Collection apis;
            ApiQuery apiQuery = new ApiQuery();
            ExecutionContext executionContext = GraviteeContext.getExecutionContext();
            if (this.isAdmin()) {
                apis = this.apiService.search(executionContext, apiQuery);
            } else {
                apiQuery.setLifecycleStates(Collections.singletonList(ApiLifecycleState.PUBLISHED));
                if (this.isAuthenticated()) {
                    apis = this.apiService.findByUser(executionContext, this.getAuthenticatedUser(), apiQuery, true);
                } else {
                    if (this.configService.portalLoginForced(executionContext)) {
                        return Response.ok().entity(Collections.emptyList()).build();
                    }
                    apiQuery.setVisibility(Visibility.PUBLIC);
                    apis = this.apiService.search(executionContext, apiQuery);
                }
            }
            HashMap filters = new HashMap();
            filters.put("api", apis.stream().map(ApiEntity::getId).collect(Collectors.toSet()));
            return Response.ok().entity(this.apiService.search(executionContext, query, filters).stream().map(api -> this.convert(executionContext, (ApiEntity)api)).collect(Collectors.toList())).build();
        }
        catch (TechnicalException te) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)te).build();
        }
    }

    private ApiListItem convert(ExecutionContext executionContext, ApiEntity api) {
        ApiListItem apiItem = new ApiListItem();
        apiItem.setId(api.getId());
        apiItem.setName(api.getName());
        apiItem.setVersion(api.getVersion());
        apiItem.setDescription(api.getDescription());
        UriBuilder ub = this.uriInfo.getBaseUriBuilder();
        UriBuilder uriBuilder = ub.path("apis").path(api.getId()).path("picture");
        if (api.getPicture() != null) {
            uriBuilder.queryParam("hash", new Object[]{api.getUpdatedAt().getTime()});
        }
        apiItem.setPictureUrl(uriBuilder.build(new Object[0]).toString());
        apiItem.setCategories(api.getCategories());
        apiItem.setCreatedAt(api.getCreatedAt());
        apiItem.setUpdatedAt(api.getUpdatedAt());
        apiItem.setLabels(api.getLabels());
        apiItem.setCategories(api.getCategories());
        apiItem.setPrimaryOwner(api.getPrimaryOwner());
        if (api.getVisibility() != null) {
            apiItem.setVisibility(Visibility.valueOf((String)api.getVisibility().toString()));
        }
        if (api.getState() != null) {
            apiItem.setState(Lifecycle.State.valueOf((String)api.getState().toString()));
        }
        if (api.getProxy() != null) {
            apiItem.setVirtualHosts(api.getProxy().getVirtualHosts());
        }
        if (this.ratingService.isEnabled(executionContext)) {
            RatingSummaryEntity ratingSummary = this.ratingService.findSummaryByApi(executionContext, api.getId());
            apiItem.setRate(ratingSummary.getAverageRate());
            apiItem.setNumberOfRatings(ratingSummary.getNumberOfRatings());
        }
        apiItem.setTags(api.getTags());
        if (api.getLifecycleState() != null) {
            apiItem.setLifecycleState(ApiLifecycleState.valueOf((String)api.getLifecycleState().toString()));
        }
        return apiItem;
    }
}

