/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.organization;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.notification.NotificationTemplateEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.notification.NotificationTemplateService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Set;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Tag(name="Notifications")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class NotificationTemplatesResource
extends AbstractResource {
    @Inject
    private NotificationTemplateService notificationTemplateService;

    @GET
    @Operation(summary="List all notification templates.", description="User must have the NOTIFICATION_TEMPLATES[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Notifications templates", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=NotificationTemplateEntity.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_NOTIFICATION_TEMPLATES, acls={RolePermissionAction.READ})})
    public Response getNotificationTemplates(@Parameter(description="filter by notification scope") @QueryParam(value="scope") String scope, @Parameter(description="filter by notification hook") @QueryParam(value="hook") String hook) {
        if (hook == null || scope == null) {
            Set all = this.notificationTemplateService.findAll(GraviteeContext.getCurrentOrganization());
            return Response.ok((Object)all).build();
        }
        Set allByHookAndScope = this.notificationTemplateService.findByHookAndScope(GraviteeContext.getCurrentOrganization(), hook, scope);
        return Response.ok((Object)allByHookAndScope).build();
    }

    @POST
    @Operation(summary="Create a notification template", description="User must have the NOTIFICATION_TEMPLATES[CREATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Created notification template", content={@Content(mediaType="application/json", schema=@Schema(implementation=NotificationTemplateEntity.class))}), @ApiResponse(responseCode="400", description="There must not be any ID in the payload"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_NOTIFICATION_TEMPLATES, acls={RolePermissionAction.CREATE})})
    public Response createNotificationTemplate(@Valid NotificationTemplateEntity newNotificationTemplateEntity) {
        NotificationTemplateEntity createdNotificationTemplate = this.notificationTemplateService.create(GraviteeContext.getExecutionContext(), newNotificationTemplateEntity);
        if (createdNotificationTemplate != null) {
            return Response.ok((Object)createdNotificationTemplate).build();
        }
        return Response.serverError().build();
    }

    @Path(value="{notificationTemplateId}")
    @GET
    @Operation(summary="Get a specific notification template.", description="User must have the NOTIFICATION_TEMPLATES[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Notification template found", content={@Content(mediaType="application/json", schema=@Schema(implementation=NotificationTemplateEntity.class))}), @ApiResponse(responseCode="404", description="Notification template not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_NOTIFICATION_TEMPLATES, acls={RolePermissionAction.READ})})
    public Response getNotificationTemplate(@Parameter(description="ID of the notification template") @PathParam(value="notificationTemplateId") String notificationTemplateId) {
        NotificationTemplateEntity notificationTemplateEntity = this.notificationTemplateService.findById(notificationTemplateId);
        return Response.ok((Object)notificationTemplateEntity).build();
    }

    @Path(value="{notificationTemplateId}")
    @PUT
    @Operation(summary="Update an existing notification template", description="User must have the NOTIFICATION_TEMPLATES[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Updated notification template", content={@Content(mediaType="application/json", schema=@Schema(implementation=NotificationTemplateEntity.class))}), @ApiResponse(responseCode="400", description="ID in path parameter is not the same as in the payload"), @ApiResponse(responseCode="404", description="Notification template not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_NOTIFICATION_TEMPLATES, acls={RolePermissionAction.UPDATE})})
    public Response updateNotificationTemplate(@Parameter(description="ID of the notification template") @PathParam(value="notificationTemplateId") String notificationTemplateId, @Valid NotificationTemplateEntity notificationTemplateEntityUpdate) {
        if (!notificationTemplateEntityUpdate.getId().equals(notificationTemplateId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        NotificationTemplateEntity updatedNotificationTemplate = this.notificationTemplateService.update(GraviteeContext.getExecutionContext(), notificationTemplateEntityUpdate);
        if (updatedNotificationTemplate != null) {
            return Response.ok((Object)updatedNotificationTemplate).build();
        }
        return Response.serverError().build();
    }
}

