/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.configuration.dictionary;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.param.LifecycleAction;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.configuration.dictionary.DictionaryEntity;
import io.gravitee.rest.api.model.configuration.dictionary.DictionaryType;
import io.gravitee.rest.api.model.configuration.dictionary.UpdateDictionaryEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.configuration.dictionary.DictionaryService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;

@Tags(value={@Tag(name="Configuration"), @Tag(name="Dictionaries")})
public class DictionaryResource
extends AbstractResource {
    @Autowired
    private DictionaryService dictionaryService;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Get a dictionary", description="User must have the DICTIONARY[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="A dictionary", content={@Content(mediaType="application/json", schema=@Schema(implementation=DictionaryEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_DICTIONARY, acls={RolePermissionAction.READ})})
    public DictionaryEntity getDictionary(@PathParam(value="dictionary") String dictionary) {
        DictionaryEntity dictionaryEntity = this.dictionaryService.findById(dictionary);
        boolean notReadOnly = this.hasPermission(GraviteeContext.getExecutionContext(), RolePermission.ENVIRONMENT_DICTIONARY, RolePermissionAction.CREATE, RolePermissionAction.UPDATE, RolePermissionAction.DELETE);
        if (!notReadOnly) {
            dictionaryEntity.setProvider(null);
            dictionaryEntity.setTrigger(null);
        }
        return dictionaryEntity;
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update a dictionary", description="User must have the DICTIONARY[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Updated dictionary", content={@Content(mediaType="application/json", schema=@Schema(implementation=DictionaryEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_DICTIONARY, acls={RolePermissionAction.UPDATE})})
    public DictionaryEntity updateDictionary(@PathParam(value="dictionary") String dictionary, @Parameter(name="dictionary", required=true) @Valid @NotNull UpdateDictionaryEntity updatedDictionary) {
        return this.dictionaryService.update(GraviteeContext.getExecutionContext(), dictionary, updatedDictionary);
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="_deploy")
    @Operation(summary="Deploy dictionary to API gateway", description="User must have the DICTIONARY[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Dictionary successfully deployed", content={@Content(mediaType="application/json", schema=@Schema(implementation=DictionaryEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_DICTIONARY, acls={RolePermissionAction.UPDATE})})
    public Response deployDictionary(@PathParam(value="dictionary") String dictionary) {
        DictionaryEntity dictionaryEntity = this.dictionaryService.findById(dictionary);
        if (dictionaryEntity.getType() == DictionaryType.MANUAL) {
            dictionaryEntity = this.dictionaryService.deploy(GraviteeContext.getExecutionContext(), dictionary);
            return Response.ok((Object)dictionaryEntity).tag(Long.toString(dictionaryEntity.getUpdatedAt().getTime())).lastModified(dictionaryEntity.getUpdatedAt()).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"An automatic dictionary can not be deployed manually").build();
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="_undeploy")
    @Operation(summary="Undeploy dictionary to API gateway", description="User must have the DICTIONARY[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Dictionary successfully undeployed", content={@Content(mediaType="application/json", schema=@Schema(implementation=DictionaryEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_DICTIONARY, acls={RolePermissionAction.UPDATE})})
    public Response undeployDictionary(@PathParam(value="dictionary") String dictionary) {
        DictionaryEntity dictionaryEntity = this.dictionaryService.findById(dictionary);
        if (dictionaryEntity.getType() == DictionaryType.MANUAL) {
            dictionaryEntity = this.dictionaryService.undeploy(GraviteeContext.getExecutionContext(), dictionary);
            return Response.ok((Object)dictionaryEntity).tag(Long.toString(dictionaryEntity.getUpdatedAt().getTime())).lastModified(dictionaryEntity.getUpdatedAt()).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"An automatic dictionary can not be undeployed manually").build();
    }

    @DELETE
    @Operation(summary="Delete a dictionary", description="User must have the DICTIONARY[DELETE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Dictionary successfully deleted"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_DICTIONARY, acls={RolePermissionAction.DELETE})})
    public Response deleteDictionary(@PathParam(value="dictionary") String dictionary) {
        this.dictionaryService.delete(GraviteeContext.getExecutionContext(), dictionary);
        return Response.noContent().build();
    }

    @POST
    @Produces(value={"application/json"})
    @Operation(summary="Manage the dictionary's lifecycle", description="User must have the DICTIONARY[LIFECYCLE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Dictionary state updated", content={@Content(mediaType="application/json", schema=@Schema(implementation=DictionaryEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_DICTIONARY, acls={RolePermissionAction.UPDATE})})
    public Response doLifecycleAction(@Context HttpHeaders headers, @Parameter(required=true) @NotNull @QueryParam(value="action") LifecycleAction action, @PathParam(value="dictionary") String dictionary) {
        DictionaryEntity dictionaryEntity = this.dictionaryService.findById(dictionary);
        if (dictionaryEntity.getType() == DictionaryType.DYNAMIC) {
            switch (action) {
                case START: {
                    this.checkLifecycle(dictionaryEntity, action);
                    dictionaryEntity = this.dictionaryService.start(GraviteeContext.getExecutionContext(), dictionary);
                    break;
                }
                case STOP: {
                    this.checkLifecycle(dictionaryEntity, action);
                    dictionaryEntity = this.dictionaryService.stop(GraviteeContext.getExecutionContext(), dictionary);
                }
            }
            return Response.ok((Object)dictionaryEntity).tag(Long.toString(dictionaryEntity.getUpdatedAt().getTime())).lastModified(dictionaryEntity.getUpdatedAt()).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"A manual dictionary can not be started/stopped manually").build();
    }

    private void checkLifecycle(DictionaryEntity dictionary, LifecycleAction action) {
        switch (dictionary.getState()) {
            case STARTED: {
                if (!LifecycleAction.START.equals((Object)action)) break;
                throw new BadRequestException("Dictionary is already started");
            }
            case STOPPED: {
                if (!LifecycleAction.STOP.equals((Object)action)) break;
                throw new BadRequestException("Dictionary is already stopped");
            }
        }
    }
}

