/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.configuration.application.registration;

import io.gravitee.rest.api.management.rest.model.configuration.application.ClientRegistrationProviderListItem;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.configuration.application.registration.ClientRegistrationProviderResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.configuration.application.registration.ClientRegistrationProviderEntity;
import io.gravitee.rest.api.model.configuration.application.registration.InitialAccessTokenType;
import io.gravitee.rest.api.model.configuration.application.registration.NewClientRegistrationProviderEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.configuration.application.ClientRegistrationService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;

@Tag(name="Client Registration Providers")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class ClientRegistrationProvidersResource
extends AbstractResource {
    @Autowired
    private ClientRegistrationService clientRegistrationService;
    @Context
    private ResourceContext resourceContext;

    @GET
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_CLIENT_REGISTRATION_PROVIDER, acls={RolePermissionAction.READ})})
    @Operation(summary="Get the list of client registration providers", description="User must have the PORTAL_CLIENT_REGISTRATION_PROVIDER[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List client registration providers", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=ClientRegistrationProviderListItem.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public List<ClientRegistrationProviderListItem> getClientRegistrationProviders() {
        return this.clientRegistrationService.findAll(GraviteeContext.getExecutionContext()).stream().map(clientRegistrationProvider -> {
            ClientRegistrationProviderListItem item = new ClientRegistrationProviderListItem();
            item.setId(clientRegistrationProvider.getId());
            item.setName(clientRegistrationProvider.getName());
            item.setDescription(clientRegistrationProvider.getDescription());
            item.setCreatedAt(clientRegistrationProvider.getCreatedAt());
            item.setUpdatedAt(clientRegistrationProvider.getUpdatedAt());
            return item;
        }).collect(Collectors.toList());
    }

    @POST
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_CLIENT_REGISTRATION_PROVIDER, acls={RolePermissionAction.CREATE})})
    @Operation(summary="Create a client registration provider", description="User must have the PORTAL_CLIENT_REGISTRATION_PROVIDER[CREATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Client registration provider provider successfully created", content={@Content(mediaType="application/json", schema=@Schema(implementation=ClientRegistrationProviderEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response createClientRegistrationProvider(@Parameter(name="identity-provider", required=true) @Valid @NotNull NewClientRegistrationProviderEntity newClientRegistrationProviderEntity) {
        ClientRegistrationProviderEntity newClientRegistrationProvider;
        if (newClientRegistrationProviderEntity.getInitialAccessTokenType() == InitialAccessTokenType.CLIENT_CREDENTIALS) {
            if (newClientRegistrationProviderEntity.getClientId() == null || newClientRegistrationProviderEntity.getClientSecret() == null) {
                throw new IllegalArgumentException("Client credentials are missing");
            }
        } else if (newClientRegistrationProviderEntity.getInitialAccessToken() == null) {
            throw new IllegalArgumentException("Access token is missing");
        }
        if ((newClientRegistrationProvider = this.clientRegistrationService.create(GraviteeContext.getExecutionContext(), newClientRegistrationProviderEntity)) != null) {
            return Response.created((URI)this.getLocationHeader(newClientRegistrationProvider.getId())).entity((Object)newClientRegistrationProvider).build();
        }
        return Response.serverError().build();
    }

    @Path(value="{clientRegistrationProvider}")
    public ClientRegistrationProviderResource getClientRegistrationProviderResource() {
        return (ClientRegistrationProviderResource)this.resourceContext.getResource(ClientRegistrationProviderResource.class);
    }
}

