/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.swagger;

import io.swagger.v3.jaxrs2.Reader;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.servers.Server;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.ws.rs.core.Application;
import org.springframework.core.env.EnvironmentCapable;
import org.springframework.util.CollectionUtils;
import org.springframework.web.context.WebApplicationContext;

public class GraviteeOpenApiReader
extends Reader {
    private Application application;

    public void setApplication(Application application) {
        this.application = application;
        super.setApplication(application);
    }

    public OpenAPI read(Set<Class<?>> classes, Map<String, Object> resources) {
        OpenAPI api = super.read(classes, resources);
        if (CollectionUtils.isEmpty((Collection)api.getServers())) {
            String server = Optional.ofNullable(this.application.getProperties()).map(map -> map.get(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE)).filter(WebApplicationContext.class::isInstance).map(WebApplicationContext.class::cast).map(EnvironmentCapable::getEnvironment).map(environment -> {
                Object url = environment.getProperty("console.api.url");
                if (url == null) {
                    String hostPortPath = environment.resolvePlaceholders("${jetty.host:localhost}:${jetty.port:8083}${http.api.management.entrypoint:${http.api.entrypoint:/}management}");
                    url = "true".equals(environment.getProperty("jetty.secured")) ? "https://" + hostPortPath : "http://" + hostPortPath;
                }
                return url;
            }).orElse("http://localhost:8083/management");
            api.addServersItem(new Server().url(server));
        }
        return api;
    }
}

