/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.quality;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.quality.QualityRuleEntity;
import io.gravitee.rest.api.model.quality.UpdateQualityRuleEntity;
import io.gravitee.rest.api.service.QualityRuleService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Tag(name="Configuration")
public class QualityRuleResource
extends AbstractResource {
    @Inject
    private QualityRuleService qualityRuleService;
    @PathParam(value="id")
    @Parameter(name="id", required=true)
    private String id;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Get a quality rule", description="User must have the MANAGEMENT_QUALITY_RULE[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Quality rule", content={@Content(mediaType="application/json", schema=@Schema(implementation=QualityRuleEntity.class))}), @ApiResponse(responseCode="404", description="Quality rule not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_QUALITY_RULE, acls={RolePermissionAction.READ})})
    public QualityRuleEntity getQualityRule() {
        return this.qualityRuleService.findById(this.id);
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update a quality rule", description="User must have the MANAGEMENT_QUALITY_RULE[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Quality rule successfully updated", content={@Content(mediaType="application/json", schema=@Schema(implementation=QualityRuleEntity.class))}), @ApiResponse(responseCode="404", description="Quality rule not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_QUALITY_RULE, acls={RolePermissionAction.UPDATE})})
    public QualityRuleEntity updateQualityRule(@Valid @NotNull UpdateQualityRuleEntity updateQualityRuleEntity) {
        updateQualityRuleEntity.setId(this.id);
        return this.qualityRuleService.update(updateQualityRuleEntity);
    }

    @DELETE
    @Consumes(value={"application/json"})
    @Operation(summary="Delete a quality rule", description="User must have the MANAGEMENT_QUALITY_RULE[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Quality rule successfully deleted"), @ApiResponse(responseCode="404", description="Quality rule not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_QUALITY_RULE, acls={RolePermissionAction.DELETE})})
    public void deleteQualityRule() {
        this.qualityRuleService.delete(this.id);
    }
}

