/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.organization;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.organization.UserTokensResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.InlinePictureEntity;
import io.gravitee.rest.api.model.MembershipMemberType;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.PictureEntity;
import io.gravitee.rest.api.model.ResetPasswordUserEntity;
import io.gravitee.rest.api.model.UrlPictureEntity;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.UserGroupEntity;
import io.gravitee.rest.api.model.UserMembershipList;
import io.gravitee.rest.api.model.UserReferenceRoleEntity;
import io.gravitee.rest.api.model.pagedresult.Metadata;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.GroupService;
import io.gravitee.rest.api.service.UserService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.ByteArrayOutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;

@Tag(name="Users")
public class UserResource
extends AbstractResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private UserService userService;
    @Inject
    private GroupService groupService;
    @PathParam(value="userId")
    @Parameter(name="userId", required=true)
    private String userId;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve a user", description="User must have the ORGANIZATION_USERS[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="A user", content={@Content(mediaType="application/json", schema=@Schema(implementation=UserEntity.class))}), @ApiResponse(responseCode="404", description="User not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_USERS, acls={RolePermissionAction.READ})})
    public UserEntity getUser() {
        UserEntity user = this.userService.findByIdWithRoles(this.userId);
        user.setPassword(null);
        user.setPicture(null);
        return user;
    }

    @DELETE
    @Operation(summary="Delete a user", description="User must have the ORGANIZATION_USERS[DELETE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="User successfully deleted"), @ApiResponse(responseCode="404", description="User not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_USERS, acls={RolePermissionAction.DELETE})})
    public Response deleteUser() {
        this.userService.delete(this.userId);
        return Response.noContent().build();
    }

    @GET
    @Path(value="/groups")
    @Produces(value={"application/json"})
    @Operation(summary="List of groups the user belongs to", description="User must have the ORGANIZATION_USERS[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of user groups", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=UserGroupEntity.class)))}), @ApiResponse(responseCode="404", description="User not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_USERS, acls={RolePermissionAction.READ})})
    public List<UserGroupEntity> getUserGroups() {
        ArrayList<UserGroupEntity> groups = new ArrayList<UserGroupEntity>();
        this.groupService.findByUser(this.userId).forEach(groupEntity -> {
            UserGroupEntity userGroupEntity = new UserGroupEntity();
            userGroupEntity.setId(groupEntity.getId());
            userGroupEntity.setName(groupEntity.getName());
            userGroupEntity.setRoles(new HashMap());
            Set roles = this.membershipService.getRoles(MembershipReferenceType.GROUP, groupEntity.getId(), MembershipMemberType.USER, this.userId);
            if (!roles.isEmpty()) {
                roles.forEach(role -> userGroupEntity.getRoles().put(role.getScope().name(), role.getName()));
            }
            groups.add(userGroupEntity);
        });
        return groups;
    }

    @GET
    @Path(value="/memberships")
    @Produces(value={"application/json"})
    @Operation(summary="List of memberships the user belongs to", description="User must have the ORGANIZATION_USERS[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of user memberships", content={@Content(mediaType="application/json", schema=@Schema(implementation=UserMembershipList.class))}), @ApiResponse(responseCode="404", description="User not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_USERS, acls={RolePermissionAction.READ})})
    public UserMembershipList getUserMemberships(@QueryParam(value="type") String sType) {
        MembershipReferenceType type = null;
        if (sType != null) {
            type = MembershipReferenceType.valueOf((String)sType.toUpperCase());
        }
        List userMemberships = this.membershipService.findUserMembership(type, this.userId);
        Metadata metadata = this.membershipService.findUserMembershipMetadata(userMemberships, type);
        UserMembershipList userMembershipList = new UserMembershipList();
        userMembershipList.setMemberships(userMemberships);
        userMembershipList.setMetadata(metadata.toMap());
        return userMembershipList;
    }

    @POST
    @Operation(summary="Reset the user's password", description="User must have the ORGANIZATION_USERS[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="User's password reset"), @ApiResponse(responseCode="400", description="reset page URL must not be null"), @ApiResponse(responseCode="404", description="User not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_USERS, acls={RolePermissionAction.UPDATE})})
    @Path(value="resetPassword")
    public Response resetUserPassword() {
        this.userService.resetPassword(this.userId);
        return Response.noContent().build();
    }

    @GET
    @Path(value="/avatar")
    @Operation(summary="Get the user's avatar")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="User's avatar", content={@Content(mediaType="*/*", schema=@Schema(type="string", format="binary"))}), @ApiResponse(responseCode="404", description="User not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getUserAvatar(@Context Request request) {
        PictureEntity picture = this.userService.getPicture(this.userId);
        if (picture instanceof UrlPictureEntity) {
            return Response.temporaryRedirect((URI)URI.create(((UrlPictureEntity)picture).getUrl())).build();
        }
        InlinePictureEntity image = (InlinePictureEntity)picture;
        if (image == null || image.getContent() == null) {
            return Response.ok().build();
        }
        CacheControl cc = new CacheControl();
        cc.setNoTransform(true);
        cc.setMustRevalidate(false);
        cc.setNoCache(false);
        cc.setMaxAge(86400);
        EntityTag etag = new EntityTag(Integer.toString(new String(image.getContent()).hashCode()));
        Response.ResponseBuilder builder = request.evaluatePreconditions(etag);
        if (builder != null) {
            return builder.cacheControl(cc).build();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(image.getContent(), 0, image.getContent().length);
        return Response.ok().entity((Object)baos).cacheControl(cc).tag(etag).type(image.getType()).build();
    }

    @PUT
    @Path(value="/roles")
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_USERS, acls={RolePermissionAction.UPDATE})})
    public Response updateUserRoles(@NotNull UserReferenceRoleEntity userReferenceRoles) {
        this.userService.updateUserRoles(this.userId, userReferenceRoles.getReferenceType(), userReferenceRoles.getReferenceId(), userReferenceRoles.getRoles());
        return Response.ok().build();
    }

    @POST
    @Path(value="/changePassword")
    @Operation(summary="Change user password after a reset", description="User registration must be enabled")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="User successfully updated", content={@Content(mediaType="application/json", schema=@Schema(implementation=UserEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response finalizeResetPassword(@Valid ResetPasswordUserEntity resetPwdEntity) {
        UserEntity newUser = this.userService.finalizeResetPassword(resetPwdEntity);
        if (newUser != null) {
            return Response.ok().entity((Object)newUser).build();
        }
        return Response.serverError().build();
    }

    @POST
    @Path(value="/_process")
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_USERS, acls={RolePermissionAction.UPDATE})})
    @Operation(summary="Process a user registration by accepting or rejecting it")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Processed user", content={@Content(mediaType="application/json", schema=@Schema(implementation=UserEntity.class))}), @ApiResponse(responseCode="404", description="User not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response validateRegistration(boolean accepted) {
        return Response.ok((Object)this.userService.processRegistration(this.userId, accepted)).build();
    }

    @Path(value="tokens")
    public UserTokensResource getUserTokensResource() {
        return (UserTokensResource)this.resourceContext.getResource(UserTokensResource.class);
    }
}

