/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.organization;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.model.UpdateUserEntity;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.service.NewsletterService;
import io.gravitee.rest.api.service.UserService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Tag(name="Newsletter")
public class NewsletterResource
extends AbstractResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private NewsletterService newsletterService;
    @Inject
    private UserService userService;

    @POST
    @Path(value="/_subscribe")
    @Operation(summary="Subscribe to the newsletter the authenticated user")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Updated user", content={@Content(schema=@Schema(implementation=UserEntity.class))}), @ApiResponse(responseCode="400", description="Invalid user profile"), @ApiResponse(responseCode="404", description="User not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response subscribeNewsletterToCurrentUser(@Valid @NotNull String email) {
        UserEntity userEntity = this.userService.findById(this.getAuthenticatedUser());
        UpdateUserEntity user = new UpdateUserEntity(userEntity);
        user.setNewsletter(Boolean.valueOf(true));
        return Response.ok((Object)this.userService.update(userEntity.getId(), user, email)).build();
    }

    @GET
    @Path(value="/taglines")
    @Operation(summary="Get taglines to display in the newsletter")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Retrieved taglines", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(type="string")))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getTaglines() {
        return Response.ok((Object)this.newsletterService.getTaglines()).build();
    }
}

