/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.organization;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.GroupSimpleEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.GroupService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Tag(name="Groups")
public class GroupsResource
extends AbstractResource {
    @Inject
    private GroupService groupService;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Find groups", description="Find all groups for current organizationOnly administrators could see all groups.Only users with MANAGE_API permissions could see API groups.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of groups", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=GroupSimpleEntity.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_GROUP, acls={RolePermissionAction.READ})})
    public Response getGroups() {
        return Response.ok((Object)this.groupService.findAllByOrganization(GraviteeContext.getCurrentOrganization())).build();
    }
}

