/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.organization;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.CustomUserFieldEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.CustomUserFieldService;
import io.gravitee.rest.api.service.exceptions.CustomUserFieldException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.net.URI;
import java.util.List;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Tag(name="Custom User Fields")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class CustomUserFieldsResource
extends AbstractResource {
    @Context
    private UriInfo uriInfo;
    @Inject
    private CustomUserFieldService fieldService;

    @GET
    @Operation(summary="List All Custom User Fields", description="User must have the CUSTOM_USER_FIELDS[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Custom User Field deleted", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=CustomUserFieldEntity.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getCustomUserFields() {
        List fields = this.fieldService.listAllFields();
        return Response.ok().entity((Object)fields).build();
    }

    @POST
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_CUSTOM_USER_FIELDS, acls={RolePermissionAction.CREATE})})
    @Operation(summary="Create a Custom User Field", description="User must have the CUSTOM_USER_FIELDS[CREATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Custom User Field Created", content={@Content(mediaType="application/json", schema=@Schema(implementation=CustomUserFieldEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response createCustomUserField(@Valid CustomUserFieldEntity newCustomUserFieldEntity) {
        CustomUserFieldEntity newField = this.fieldService.create(newCustomUserFieldEntity);
        if (newField != null) {
            return Response.created((URI)URI.create(this.uriInfo.getPath() + "/" + newField.getKey())).entity((Object)newField).build();
        }
        return Response.serverError().build();
    }

    @PUT
    @Path(value="{key}")
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_CUSTOM_USER_FIELDS, acls={RolePermissionAction.UPDATE})})
    @Operation(summary="Update a Custom User Field", description="User must have the CUSTOM_USER_FIELDS[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Custom User Field updated", content={@Content(mediaType="application/json", schema=@Schema(implementation=CustomUserFieldEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response updateCustomUserField(@PathParam(value="key") String key, @Valid CustomUserFieldEntity toUpdateFieldEntity) {
        if (toUpdateFieldEntity == null || !key.toLowerCase().equals(toUpdateFieldEntity.getKey().toLowerCase())) {
            throw new CustomUserFieldException(key, "update");
        }
        CustomUserFieldEntity updatedField = this.fieldService.update(toUpdateFieldEntity);
        if (updatedField != null) {
            return Response.ok().entity((Object)updatedField).build();
        }
        return Response.serverError().build();
    }

    @DELETE
    @Path(value="{key}")
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_CUSTOM_USER_FIELDS, acls={RolePermissionAction.DELETE})})
    @Operation(summary="Delete a Custom User Field", description="User must have the CUSTOM_USER_FIELDS[DELETE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Custom User Field deleted"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response deleteCustomUserField(@PathParam(value="key") String key) {
        this.fieldService.delete(key);
        return Response.noContent().build();
    }
}

