/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.organization;

import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.settings.ConsoleSettingsEntity;
import io.gravitee.rest.api.service.ConfigService;
import io.gravitee.rest.api.service.ParameterService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.MaintenanceModeException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Tag(name="Settings")
public class ConsoleSettingsResource {
    @Inject
    private ConfigService configService;
    @Inject
    private ParameterService parameterService;
    @Context
    private ResourceContext resourceContext;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Get the console settings")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Console configuration", content={@Content(mediaType="application/json", schema=@Schema(implementation=ConsoleSettingsEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_SETTINGS, acls={RolePermissionAction.READ})})
    public ConsoleSettingsEntity getConsoleSettings() {
        return this.configService.getConsoleSettings(GraviteeContext.getCurrentOrganization());
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Operation(summary="Save the console settings")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Updated console settings", content={@Content(mediaType="application/json", schema=@Schema(implementation=ConsoleSettingsEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_SETTINGS, acls={RolePermissionAction.CREATE, RolePermissionAction.UPDATE, RolePermissionAction.DELETE})})
    public Response saveConsoleSettings(@Parameter(name="config", required=true) @NotNull ConsoleSettingsEntity consoleSettingsEntity) {
        this.checkMaintenanceMode(consoleSettingsEntity);
        this.configService.save(GraviteeContext.getCurrentOrganization(), consoleSettingsEntity);
        return Response.ok().entity((Object)consoleSettingsEntity).build();
    }

    private void checkMaintenanceMode(ConsoleSettingsEntity consoleSettingsEntity) {
        boolean maintenanceMode = this.parameterService.findAsBoolean(Key.MAINTENANCE_MODE_ENABLED, GraviteeContext.getCurrentOrganization(), ParameterReferenceType.ORGANIZATION);
        if (maintenanceMode && (consoleSettingsEntity.getMaintenance() == null || consoleSettingsEntity.getMaintenance().getEnabled() == null || consoleSettingsEntity.getMaintenance().getEnabled().booleanValue())) {
            throw new MaintenanceModeException();
        }
    }
}

