/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.configuration.dictionary;

import io.gravitee.rest.api.management.rest.model.configuration.dictionary.DictionaryListItem;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.configuration.dictionary.DictionaryResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.configuration.dictionary.DictionaryEntity;
import io.gravitee.rest.api.model.configuration.dictionary.NewDictionaryEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.configuration.dictionary.DictionaryService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;

@Tags(value={@Tag(name="Configuration"), @Tag(name="Dictionaries")})
public class DictionariesResource
extends AbstractResource {
    @Autowired
    private DictionaryService dictionaryService;
    @Context
    private ResourceContext resourceContext;

    @GET
    @Produces(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_DICTIONARY, acls={RolePermissionAction.READ})})
    @Operation(summary="Get the list of global dictionaries", description="User must have the DICTIONARY[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List global dictionaries", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=DictionaryListItem.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public List<DictionaryListItem> getDictionaries() {
        return this.dictionaryService.findAll().stream().map(dictionaryEntity -> {
            DictionaryListItem item = new DictionaryListItem();
            item.setId(dictionaryEntity.getId());
            item.setName(dictionaryEntity.getName());
            item.setDescription(dictionaryEntity.getDescription());
            item.setCreatedAt(dictionaryEntity.getCreatedAt());
            item.setUpdatedAt(dictionaryEntity.getUpdatedAt());
            item.setDeployedAt(dictionaryEntity.getDeployedAt());
            item.setType(dictionaryEntity.getType());
            item.setState(dictionaryEntity.getState());
            if (dictionaryEntity.getProperties() != null) {
                item.setProperties(dictionaryEntity.getProperties().size());
            }
            if (dictionaryEntity.getProvider() != null) {
                item.setProvider(dictionaryEntity.getProvider().getType());
            }
            return item;
        }).collect(Collectors.toList());
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_DICTIONARY, acls={RolePermissionAction.CREATE})})
    @Operation(summary="Create a dictionary", description="User must have the DICTIONARY[CREATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Dictionary successfully created", content={@Content(mediaType="application/json", schema=@Schema(implementation=DictionaryEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response createDictionary(@Parameter(name="dictionary", required=true) @Valid @NotNull NewDictionaryEntity newDictionaryEntity) {
        DictionaryEntity newDictionary = this.dictionaryService.create(newDictionaryEntity);
        if (newDictionary != null) {
            return Response.created((URI)this.getLocationHeader(newDictionary.getId())).entity((Object)newDictionary).build();
        }
        return Response.serverError().build();
    }

    @Path(value="{dictionary}")
    public DictionaryResource getDictionaryResource() {
        return (DictionaryResource)this.resourceContext.getResource(DictionaryResource.class);
    }
}

