/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.NewTopApiEntity;
import io.gravitee.rest.api.model.TopApiEntity;
import io.gravitee.rest.api.model.UpdateTopApiEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.TopApiService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.UriBuilder;

@Tag(name="Top APIs")
public class TopApisResource
extends AbstractResource {
    @Inject
    private TopApiService topApiService;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="List of top APIs", description="User must have the PORTAL_TOP_APIS[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of top APIs", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=TopApiEntity.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_TOP_APIS, acls={RolePermissionAction.READ})})
    public List<TopApiEntity> getTopApis() {
        return this.topApiService.findAll().stream().peek(this.addPictureUrl()).collect(Collectors.toList());
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create a top API", description="User must have the PORTAL_TOP_APIS[CREATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of top APIs", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=TopApiEntity.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_TOP_APIS, acls={RolePermissionAction.CREATE})})
    public List<TopApiEntity> createTopApi(@Valid @NotNull NewTopApiEntity topApi) {
        return this.topApiService.create(topApi).stream().peek(this.addPictureUrl()).collect(Collectors.toList());
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update a top API", description="User must have the PORTAL_TOP_APIS[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of top APIs", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=TopApiEntity.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_TOP_APIS, acls={RolePermissionAction.UPDATE})})
    public List<TopApiEntity> updateTopApi(@Valid @NotNull List<UpdateTopApiEntity> topApis) {
        return this.topApiService.update(topApis).stream().peek(this.addPictureUrl()).collect(Collectors.toList());
    }

    @Path(value="{topAPI}")
    @DELETE
    @Consumes(value={"application/json"})
    @Operation(summary="Delete an existing top API", description="User must have the PORTAL_TOP_APIS[DELETE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Top API successfully deleted"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_TOP_APIS, acls={RolePermissionAction.DELETE})})
    public void deleteTopApi(@PathParam(value="topAPI") String topAPI) {
        this.topApiService.delete(topAPI);
    }

    private Consumer<TopApiEntity> addPictureUrl() {
        return topApiEntity -> {
            UriBuilder ub = this.uriInfo.getBaseUriBuilder();
            UriBuilder uriBuilder = ub.path("organizations").path(GraviteeContext.getCurrentOrganization()).path("environments").path(GraviteeContext.getCurrentEnvironment()).path("apis").path(topApiEntity.getApi()).path("picture");
            topApiEntity.setPictureUrl(uriBuilder.build(new Object[0]).toString());
        };
    }
}

