/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.model.NewTokenEntity;
import io.gravitee.rest.api.model.TokenEntity;
import io.gravitee.rest.api.service.TokenService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Tag(name="User Tokens")
public class TokensResource
extends AbstractResource {
    @Inject
    private TokenService tokenService;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="List user's personal tokens")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="User's personal tokens", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=TokenEntity.class)))}), @ApiResponse(responseCode="404", description="User not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public List<TokenEntity> getTokens() {
        return this.tokenService.findByUser(this.getAuthenticatedUser()).stream().sorted(Comparator.comparing(TokenEntity::getCreatedAt)).collect(Collectors.toList());
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create a personal token")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="A new personal token", content={@Content(mediaType="application/json", schema=@Schema(implementation=TokenEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public TokenEntity createTokens(@Valid @NotNull NewTokenEntity token) {
        return this.tokenService.create(token, this.getAuthenticatedUser());
    }

    @DELETE
    @Consumes(value={"application/json"})
    @Operation(summary="Revoke all user's personal tokens")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="User's personal tokens revoked"), @ApiResponse(responseCode="404", description="User not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public void revokeAllTokens() {
        this.tokenService.revokeByUser(this.getAuthenticatedUser());
    }

    @Path(value="{token}")
    @DELETE
    @Consumes(value={"application/json"})
    @Operation(summary="Revoke a single user's personal tokens")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="User's personal token revoked"), @ApiResponse(responseCode="404", description="User not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public void revokeToken(@PathParam(value="token") String tokenId) {
        this.tokenService.revoke(tokenId);
    }
}

