/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.InlinePictureEntity;
import io.gravitee.rest.api.model.PictureEntity;
import io.gravitee.rest.api.model.UrlPictureEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.theme.ThemeEntity;
import io.gravitee.rest.api.model.theme.UpdateThemeEntity;
import io.gravitee.rest.api.service.ThemeService;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.ByteArrayOutputStream;
import java.net.URI;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;

@Tag(name="Themes")
public class ThemeResource
extends AbstractResource {
    @Inject
    private ThemeService themeService;
    @PathParam(value="themeId")
    @Parameter(name="themeId", required=true)
    private String themeId;

    @GET
    @Produces(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_THEME, acls={RolePermissionAction.READ})})
    public ThemeEntity getTheme() {
        return this.themeService.findEnabled();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_THEME, acls={RolePermissionAction.UPDATE})})
    public ThemeEntity updateTheme(@Valid @NotNull UpdateThemeEntity theme) {
        theme.setId(this.themeId);
        return this.themeService.update(theme);
    }

    @Path(value="/reset")
    @POST
    @Produces(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_THEME, acls={RolePermissionAction.UPDATE})})
    public ThemeEntity resetTheme() {
        return this.themeService.resetToDefaultTheme(this.themeId);
    }

    @DELETE
    @Consumes(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_THEME, acls={RolePermissionAction.DELETE})})
    public void deleteTheme() {
        this.themeService.delete(this.themeId);
    }

    @GET
    @Path(value="/logo")
    public Response getThemeLogo(@Context Request request) {
        return this.buildPictureResponse(this.themeService.getLogo(this.themeId), request);
    }

    @GET
    @Path(value="/optionalLogo")
    public Response getLogoLight(@Context Request request) {
        return this.buildPictureResponse(this.themeService.getOptionalLogo(this.themeId), request);
    }

    @GET
    @Path(value="/favicon")
    public Response getFavicon(@Context Request request) {
        return this.buildPictureResponse(this.themeService.getFavicon(this.themeId), request);
    }

    @GET
    @Path(value="/backgroundImage")
    public Response getThemeBackground(@Context Request request) {
        return this.buildPictureResponse(this.themeService.getBackgroundImage(this.themeId), request);
    }

    private Response buildPictureResponse(PictureEntity picture, @Context Request request) {
        if (picture == null) {
            return Response.ok().build();
        }
        if (picture instanceof UrlPictureEntity) {
            return Response.temporaryRedirect((URI)URI.create(((UrlPictureEntity)picture).getUrl())).build();
        }
        CacheControl cc = new CacheControl();
        cc.setNoTransform(true);
        cc.setMustRevalidate(false);
        cc.setNoCache(false);
        cc.setMaxAge(86400);
        InlinePictureEntity image = (InlinePictureEntity)picture;
        EntityTag etag = new EntityTag(Integer.toString(new String(image.getContent()).hashCode()));
        Response.ResponseBuilder builder = request.evaluatePreconditions(etag);
        if (builder != null) {
            return builder.cacheControl(cc).build();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(image.getContent(), 0, image.getContent().length);
        return Response.ok().entity((Object)baos).cacheControl(cc).tag(etag).type(image.getType()).build();
    }
}

