/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.model.promotion.PromotionEntity;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.promotion.PromotionService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.inject.Inject;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Tag(name="Promotion")
public class PromotionResource
extends AbstractResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private PromotionService promotionService;
    @PathParam(value="promotion")
    @Parameter(name="promotion", required=true, description="The ID of the promotion")
    private String promotion;

    @POST
    @Path(value="/_process")
    @Operation(summary="Process an API promotion by accepting or rejecting it")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Processed promotion", content={@Content(mediaType="application/json", schema=@Schema(implementation=PromotionEntity.class))}), @ApiResponse(responseCode="404", description="Promotion not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response processPromotion(boolean accepted) {
        return Response.ok((Object)this.promotionService.processPromotion(GraviteeContext.getCurrentOrganization(), GraviteeContext.getCurrentEnvironment(), this.promotion, accepted)).build();
    }
}

