/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.common.data.domain.Page;
import io.gravitee.rest.api.management.rest.model.wrapper.AlertEventPage;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.param.AlertAnalyticsParam;
import io.gravitee.rest.api.management.rest.resource.param.AlertEventSearchParam;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.AlertAnalyticsQuery;
import io.gravitee.rest.api.model.AlertEventQuery;
import io.gravitee.rest.api.model.alert.AlertAnalyticsEntity;
import io.gravitee.rest.api.model.alert.AlertEventEntity;
import io.gravitee.rest.api.model.alert.AlertReferenceType;
import io.gravitee.rest.api.model.alert.AlertStatusEntity;
import io.gravitee.rest.api.model.alert.AlertTriggerEntity;
import io.gravitee.rest.api.model.alert.NewAlertTriggerEntity;
import io.gravitee.rest.api.model.alert.UpdateAlertTriggerEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.AlertAnalyticsService;
import io.gravitee.rest.api.service.AlertService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Tag(name="Platform Alerts")
public class PlatformAlertsResource
extends AbstractResource {
    private static final String PLATFORM_REFERENCE_ID = "default";
    @Inject
    private AlertService alertService;
    @Inject
    private AlertAnalyticsService alertAnalyticsService;

    @GET
    @Operation(summary="List configured alerts of the platform", description="User must have the MANAGEMENT_ALERT[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of alerts", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=AlertTriggerEntity.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Produces(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_ALERT, acls={RolePermissionAction.READ})})
    public List<AlertTriggerEntity> getPlatformAlerts(@QueryParam(value="event_counts") @DefaultValue(value="true") Boolean withEventCounts) {
        return withEventCounts != false ? this.alertService.findByReferenceWithEventCounts(AlertReferenceType.PLATFORM, PLATFORM_REFERENCE_ID) : this.alertService.findByReference(AlertReferenceType.PLATFORM, PLATFORM_REFERENCE_ID);
    }

    @GET
    @Path(value="analytics")
    @Operation(summary="List configured alerts of the platform", description="User must have the MANAGEMENT_ALERT[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of alerts", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=AlertTriggerEntity.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Produces(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_ALERT, acls={RolePermissionAction.READ})})
    public AlertAnalyticsEntity getPlatformAlertsAnalytics(@BeanParam AlertAnalyticsParam param) {
        param.validate();
        return this.alertAnalyticsService.findByReference(AlertReferenceType.PLATFORM, PLATFORM_REFERENCE_ID, new AlertAnalyticsQuery.Builder().from(param.getFrom().longValue()).to(param.getTo().longValue()).build());
    }

    @GET
    @Path(value="status")
    @Operation(summary="Get alerting status", description="User must have the MANAGEMENT_ALERT[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Alerting status", content={@Content(mediaType="application/json", schema=@Schema(implementation=AlertStatusEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Produces(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_ALERT, acls={RolePermissionAction.READ})})
    public AlertStatusEntity getPlatformAlertStatus() {
        return this.alertService.getStatus();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create an alert for the platform", description="User must have the MANAGEMENT_ALERT[CREATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Alert successfully created", content={@Content(mediaType="application/json", schema=@Schema(implementation=AlertTriggerEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_ALERT, acls={RolePermissionAction.CREATE})})
    public AlertTriggerEntity createPlatformAlert(@Valid @NotNull NewAlertTriggerEntity alertEntity) {
        alertEntity.setReferenceType(AlertReferenceType.PLATFORM);
        alertEntity.setReferenceId(PLATFORM_REFERENCE_ID);
        return this.alertService.create(alertEntity);
    }

    @Path(value="{alert}")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update an alert for the platform", description="User must have the MANAGEMENT_ALERT[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Alert successfully updated", content={@Content(mediaType="application/json", schema=@Schema(implementation=AlertTriggerEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_ALERT, acls={RolePermissionAction.UPDATE})})
    public AlertTriggerEntity updatePlatformAlert(@PathParam(value="alert") String alert, @Valid @NotNull UpdateAlertTriggerEntity alertEntity) {
        alertEntity.setId(alert);
        alertEntity.setReferenceType(AlertReferenceType.PLATFORM);
        alertEntity.setReferenceId(PLATFORM_REFERENCE_ID);
        return this.alertService.update(alertEntity);
    }

    @POST
    @Path(value="{alert}")
    @Operation(summary="Associate the alert to multiple references (API, APPLICATION", description="User must have the MANAGEMENT_ALERT[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Alert successfully associated"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_ALERT, acls={RolePermissionAction.UPDATE})})
    public Response associatePlatformAlert(@PathParam(value="alert") String alert, @QueryParam(value="type") String type) {
        this.alertService.applyDefaults(alert, AlertReferenceType.valueOf((String)type.toUpperCase()));
        return Response.ok().build();
    }

    @Path(value="{alert}")
    @DELETE
    @Consumes(value={"application/json"})
    @Operation(summary="Delete an alert for the platform", description="User must have the MANAGEMENT_ALERT[DELETE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Alert successfully deleted"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_ALERT, acls={RolePermissionAction.DELETE})})
    public void deletePlatformAlert(@PathParam(value="alert") String alert) {
        this.alertService.delete(alert, PLATFORM_REFERENCE_ID);
    }

    @GET
    @Path(value="{alert}/events")
    @Operation(summary="Retrieve the list of events for an alert", description="User must have the MANAGEMENT_ALERT[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of events", content={@Content(mediaType="application/json", schema=@Schema(implementation=AlertEventPage.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Produces(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_ALERT, acls={RolePermissionAction.READ})})
    public AlertEventPage getPlatformAlertEvents(@PathParam(value="alert") String alert, @BeanParam AlertEventSearchParam param) {
        return new AlertEventPage((Page<AlertEventEntity>)this.alertService.findEvents(alert, new AlertEventQuery.Builder().from(param.getFrom().longValue()).to(param.getTo().longValue()).pageNumber(param.getPage().intValue()).pageSize(param.getSize().intValue()).build()));
    }
}

