/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.param.Aggregation;
import io.gravitee.rest.api.management.rest.resource.param.AnalyticsParam;
import io.gravitee.rest.api.management.rest.resource.param.Range;
import io.gravitee.rest.api.model.analytics.Analytics;
import io.gravitee.rest.api.model.analytics.HistogramAnalytics;
import io.gravitee.rest.api.model.analytics.TopHitsAnalytics;
import io.gravitee.rest.api.model.analytics.query.AbstractQuery;
import io.gravitee.rest.api.model.analytics.query.AggregationType;
import io.gravitee.rest.api.model.analytics.query.CountQuery;
import io.gravitee.rest.api.model.analytics.query.DateHistogramQuery;
import io.gravitee.rest.api.model.analytics.query.GroupByQuery;
import io.gravitee.rest.api.model.analytics.query.StatsAnalytics;
import io.gravitee.rest.api.model.analytics.query.StatsQuery;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.api.ApiQuery;
import io.gravitee.rest.api.model.application.ApplicationListItem;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.AnalyticsService;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.ApplicationService;
import io.gravitee.rest.api.service.PermissionService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.BeanParam;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.jetbrains.annotations.NotNull;

@Tag(name="Environment Analytics")
public class EnvironmentAnalyticsResource
extends AbstractResource {
    public static final String API_FIELD = "api";
    public static final String APPLICATION_FIELD = "application";
    public static final String STATE_FIELD = "state";
    public static final String LIFECYCLE_STATE_FIELD = "lifecycle_state";
    @Inject
    private AnalyticsService analyticsService;
    @Inject
    ApiService apiService;
    @Inject
    PermissionService permissionService;
    @Inject
    ApplicationService applicationService;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Get environment analytics")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Environment analytics", content={@Content(mediaType="application/json", schema=@Schema(implementation=Analytics.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getPlatformAnalytics(@BeanParam AnalyticsParam analyticsParam) {
        analyticsParam.validate();
        HistogramAnalytics analytics = null;
        String extraFilter = null;
        if (!this.isAdmin()) {
            List<String> ids;
            String fieldName;
            if (APPLICATION_FIELD.equals(analyticsParam.getField())) {
                fieldName = APPLICATION_FIELD;
                ids = this.applicationService.findByUser(GraviteeContext.getCurrentOrganization(), GraviteeContext.getCurrentEnvironment(), this.getAuthenticatedUser()).stream().map(ApplicationListItem::getId).filter(appId -> this.permissionService.hasPermission(RolePermission.APPLICATION_ANALYTICS, appId, new RolePermissionAction[]{RolePermissionAction.READ})).collect(Collectors.toList());
            } else {
                fieldName = API_FIELD;
                ids = this.apiService.findByUser(this.getAuthenticatedUser(), null, false).stream().map(ApiEntity::getId).filter(apiId -> this.permissionService.hasPermission(RolePermission.API_ANALYTICS, apiId, new RolePermissionAction[]{RolePermissionAction.READ})).collect(Collectors.toList());
            }
            extraFilter = this.getExtraFilter(fieldName, ids);
        }
        if (analyticsParam.getQuery() != null) {
            analyticsParam.setQuery(analyticsParam.getQuery().replaceAll("\\?", "1"));
        }
        switch (analyticsParam.getType()) {
            case DATE_HISTO: {
                analytics = !this.isAdmin() && extraFilter == null ? new HistogramAnalytics() : this.executeDateHisto(analyticsParam, extraFilter);
                break;
            }
            case GROUP_BY: {
                analytics = !this.isAdmin() && extraFilter == null ? new TopHitsAnalytics() : this.executeGroupBy(analyticsParam, extraFilter);
                break;
            }
            case COUNT: {
                analytics = !this.isAdmin() && extraFilter == null ? new StatsAnalytics() : this.executeCount(analyticsParam, extraFilter);
                break;
            }
            case STATS: {
                analytics = !this.isAdmin() && extraFilter == null ? new StatsAnalytics() : this.executeStats(analyticsParam, extraFilter);
            }
        }
        return Response.ok(analytics).build();
    }

    private Analytics executeStats(AnalyticsParam analyticsParam, String extraFilter) {
        StatsQuery query = new StatsQuery();
        query.setFrom(analyticsParam.getFrom());
        query.setTo(analyticsParam.getTo());
        query.setInterval(analyticsParam.getInterval());
        query.setQuery(analyticsParam.getQuery());
        query.setField(analyticsParam.getField());
        this.addExtraFilter((AbstractQuery)query, extraFilter);
        return this.analyticsService.execute(query);
    }

    private Analytics executeCount(AnalyticsParam analyticsParam, String extraFilter) {
        CountQuery query = new CountQuery();
        query.setFrom(analyticsParam.getFrom());
        query.setTo(analyticsParam.getTo());
        query.setInterval(analyticsParam.getInterval());
        query.setQuery(analyticsParam.getQuery());
        this.addExtraFilter((AbstractQuery)query, extraFilter);
        switch (analyticsParam.getField()) {
            case "api": {
                if (this.isAdmin()) {
                    return this.buildCountStat(this.apiService.search(new ApiQuery()).size());
                }
                return this.buildCountStat(this.apiService.findByUser(this.getAuthenticatedUser(), new ApiQuery(), false).size());
            }
            case "application": {
                if (this.isAdmin()) {
                    return this.buildCountStat(this.applicationService.findAll(GraviteeContext.getCurrentOrganization(), GraviteeContext.getCurrentEnvironment()).size());
                }
                return this.buildCountStat(this.applicationService.findByUser(GraviteeContext.getCurrentOrganization(), GraviteeContext.getCurrentEnvironment(), this.getAuthenticatedUser()).size());
            }
        }
        return this.analyticsService.execute(query);
    }

    private StatsAnalytics buildCountStat(float countValue) {
        StatsAnalytics stats = new StatsAnalytics();
        stats.setCount(Float.valueOf(countValue));
        return stats;
    }

    private Analytics executeDateHisto(AnalyticsParam analyticsParam, String extraFilter) {
        DateHistogramQuery query = new DateHistogramQuery();
        query.setFrom(analyticsParam.getFrom());
        query.setTo(analyticsParam.getTo());
        query.setInterval(analyticsParam.getInterval());
        query.setQuery(analyticsParam.getQuery());
        List<Aggregation> aggregations = analyticsParam.getAggregations();
        if (aggregations != null) {
            List aggregationList = aggregations.stream().map(aggregation -> new io.gravitee.rest.api.model.analytics.query.Aggregation((Aggregation)aggregation){
                final /* synthetic */ Aggregation val$aggregation;
                {
                    this.val$aggregation = aggregation;
                }

                public AggregationType type() {
                    return AggregationType.valueOf((String)this.val$aggregation.getType().name().toUpperCase());
                }

                public String field() {
                    return this.val$aggregation.getField();
                }
            }).collect(Collectors.toList());
            query.setAggregations(aggregationList);
        }
        this.addExtraFilter((AbstractQuery)query, extraFilter);
        return this.analyticsService.execute(GraviteeContext.getCurrentOrganization(), query);
    }

    private Analytics executeGroupBy(AnalyticsParam analyticsParam, String extraFilter) {
        List<Range> ranges;
        GroupByQuery query = new GroupByQuery();
        query.setFrom(analyticsParam.getFrom());
        query.setTo(analyticsParam.getTo());
        query.setInterval(analyticsParam.getInterval());
        query.setQuery(analyticsParam.getQuery());
        query.setField(analyticsParam.getField());
        if (analyticsParam.getOrder() != null) {
            GroupByQuery.Order order = new GroupByQuery.Order();
            order.setField(analyticsParam.getOrder().getField());
            order.setType(analyticsParam.getOrder().getType());
            order.setOrder(analyticsParam.getOrder().isOrder());
            query.setOrder(order);
        }
        if ((ranges = analyticsParam.getRanges()) != null) {
            Map<Double, Double> rangeMap = ranges.stream().collect(Collectors.toMap(Range::getFrom, Range::getTo));
            query.setGroups(rangeMap);
        }
        this.addExtraFilter((AbstractQuery)query, extraFilter);
        switch (analyticsParam.getField()) {
            case "state": {
                return this.getTopHitsAnalytics(api -> api.getState().name());
            }
            case "lifecycle_state": {
                return this.getTopHitsAnalytics(api -> api.getLifecycleState().name());
            }
        }
        return this.analyticsService.execute(GraviteeContext.getCurrentOrganization(), query);
    }

    @NotNull
    private TopHitsAnalytics getTopHitsAnalytics(Function<ApiEntity, String> groupingByFunction) {
        Set apis = this.isAdmin() ? new HashSet(this.apiService.search(new ApiQuery())) : this.apiService.findByUser(this.getAuthenticatedUser(), new ApiQuery(), false);
        Map<String, Long> collect = apis.stream().collect(Collectors.groupingBy(groupingByFunction, Collectors.counting()));
        TopHitsAnalytics topHitsAnalytics = new TopHitsAnalytics();
        topHitsAnalytics.setValues(collect);
        return topHitsAnalytics;
    }

    private void addExtraFilter(AbstractQuery query, String extraFilter) {
        if (query.getQuery() == null || query.getQuery().isEmpty()) {
            query.setQuery(extraFilter);
        } else if (extraFilter != null && !extraFilter.isEmpty()) {
            query.setQuery(query.getQuery() + " AND " + extraFilter);
        } else {
            query.setQuery(query.getQuery());
        }
    }

    private String getExtraFilter(String fieldName, List<String> ids) {
        if (ids != null && !ids.isEmpty()) {
            return fieldName + ":(" + String.join((CharSequence)" OR ", ids) + ")";
        }
        return null;
    }
}

