/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.repository.management.model.ApplicationStatus;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.ApplicationResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.ApplicationEntity;
import io.gravitee.rest.api.model.NewApplicationEntity;
import io.gravitee.rest.api.model.application.ApplicationListItem;
import io.gravitee.rest.api.model.application.ApplicationSettings;
import io.gravitee.rest.api.model.application.SimpleApplicationSettings;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.ApplicationService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.ForbiddenAccessException;
import io.gravitee.rest.api.service.notification.ApplicationHook;
import io.gravitee.rest.api.service.notification.Hook;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;

@Tag(name="Applications")
public class ApplicationsResource
extends AbstractResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private ApplicationService applicationService;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="List all the applications accessible to authenticated user", description="User must have MANAGEMENT_APPLICATION[READ] and PORTAL_APPLICATION[READ] permission to list applications.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="User's applications", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=ApplicationEntity.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_APPLICATION, acls={RolePermissionAction.READ})})
    public List<ApplicationListItem> getApplications(@QueryParam(value="group") String group, @QueryParam(value="query") String query, @QueryParam(value="status") @DefaultValue(value="ACTIVE") String status) {
        Set<ApplicationListItem> applications;
        if (!this.isAdmin() && ApplicationStatus.ARCHIVED.name().equalsIgnoreCase(status)) {
            throw new ForbiddenAccessException();
        }
        if (query != null && !query.trim().isEmpty()) {
            applications = this.applicationService.findByUserAndNameAndStatus(this.getAuthenticatedUser(), this.isAdmin(), query, status, GraviteeContext.getCurrentEnvironment(), GraviteeContext.getCurrentOrganization());
        } else if (this.isAdmin()) {
            applications = group != null ? this.applicationService.findByGroupsAndStatus(GraviteeContext.getCurrentOrganization(), Collections.singletonList(group), status) : this.applicationService.findByStatus(GraviteeContext.getCurrentOrganization(), GraviteeContext.getCurrentEnvironment(), status);
        } else {
            applications = this.applicationService.findByUser(GraviteeContext.getCurrentOrganization(), GraviteeContext.getCurrentEnvironment(), this.getAuthenticatedUser());
            if (group != null && !group.isEmpty()) {
                applications = applications.stream().filter(app -> app.getGroups() != null && app.getGroups().contains(group)).collect(Collectors.toSet());
            }
        }
        applications.forEach(application -> this.addPictureUrl((ApplicationListItem)application));
        return applications.stream().sorted((o1, o2) -> ApplicationStatus.ACTIVE.name().equalsIgnoreCase(status) ? String.CASE_INSENSITIVE_ORDER.compare(o1.getName(), o2.getName()) : o2.getUpdatedAt().compareTo(o1.getUpdatedAt())).collect(Collectors.toList());
    }

    private void addPictureUrl(ApplicationListItem application) {
        UriBuilder ub = this.uriInfo.getBaseUriBuilder();
        UriBuilder uriBuilder = ub.path("organizations").path(GraviteeContext.getCurrentOrganization()).path("environments").path(GraviteeContext.getCurrentEnvironment()).path("applications").path(application.getId()).path("picture");
        uriBuilder.queryParam("hash", new Object[]{application.getUpdatedAt().getTime()});
        application.setPicture(null);
        application.setPictureUrl(uriBuilder.build(new Object[0]).toString());
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Operation(summary="Create an application", description="User must have MANAGEMENT_APPLICATION[CREATE] permission to create an application.")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Application successfully created", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApplicationEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_APPLICATION, acls={RolePermissionAction.CREATE})})
    public Response createApplication(@Parameter(name="application", required=true) @Valid @NotNull(message="An application must be provided") @Valid @NotNull(message="An application must be provided") NewApplicationEntity application) {
        ApplicationEntity newApplication;
        if (application.getSettings() == null || application.getSettings().getoAuthClient() == null && application.getSettings().getApp() == null) {
            ApplicationSettings settings = new ApplicationSettings();
            SimpleApplicationSettings simpleAppSettings = new SimpleApplicationSettings();
            simpleAppSettings.setType(application.getType());
            simpleAppSettings.setClientId(application.getClientId());
            settings.setApp(simpleAppSettings);
            application.setSettings(settings);
        }
        if ((newApplication = this.applicationService.create(GraviteeContext.getCurrentEnvironment(), application, this.getAuthenticatedUser())) != null) {
            return Response.created((URI)this.getLocationHeader(newApplication.getId())).entity((Object)newApplication).build();
        }
        return Response.serverError().build();
    }

    @GET
    @Path(value="/hooks")
    @Operation(summary="Get the list of available hooks")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of hooks", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=Hook.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Produces(value={"application/json"})
    public Hook[] getApplicationHooks() {
        return ApplicationHook.values();
    }

    @Path(value="{application}")
    public ApplicationResource getApplicationResource() {
        return (ApplicationResource)this.resourceContext.getResource(ApplicationResource.class);
    }
}

