/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.model.ApplicationMembership;
import io.gravitee.rest.api.management.rest.model.TransferOwnership;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.ApplicationEntity;
import io.gravitee.rest.api.model.MemberEntity;
import io.gravitee.rest.api.model.MembershipListItem;
import io.gravitee.rest.api.model.MembershipMemberType;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.RoleEntity;
import io.gravitee.rest.api.model.permissions.ApplicationPermission;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.model.permissions.SystemRole;
import io.gravitee.rest.api.service.ApplicationService;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.SinglePrimaryOwnerException;
import io.gravitee.rest.api.service.exceptions.UserNotFoundException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Tag(name="Application Memberships")
public class ApplicationMembersResource
extends AbstractResource {
    @Inject
    private MembershipService membershipService;
    @Inject
    private ApplicationService applicationService;
    @Inject
    private UserService userService;
    @PathParam(value="application")
    @Parameter(name="application", hidden=true)
    private String application;

    @GET
    @Path(value="/permissions")
    @Produces(value={"application/json"})
    @Operation(summary="Get application members", description="User must have the APPLICATION_MEMBER permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Application member's permissions", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=MemberEntity.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getApplicationMemberPermissions() {
        Map<String, char[]> permissions = new HashMap();
        if (this.isAuthenticated()) {
            String username = this.getAuthenticatedUser();
            ApplicationEntity applicationEntity = this.applicationService.findById(GraviteeContext.getCurrentEnvironment(), this.application);
            if (this.isAdmin()) {
                char[] rights = new char[]{RolePermissionAction.CREATE.getId(), RolePermissionAction.READ.getId(), RolePermissionAction.UPDATE.getId(), RolePermissionAction.DELETE.getId()};
                for (ApplicationPermission perm : ApplicationPermission.values()) {
                    permissions.put(perm.getName(), rights);
                }
            } else {
                permissions = this.membershipService.getUserMemberPermissions(GraviteeContext.getCurrentEnvironment(), applicationEntity, username);
            }
        }
        return Response.ok(permissions).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="List application members", description="User must have the READ permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Application successfully deleted", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=MembershipListItem.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_MEMBER, acls={RolePermissionAction.READ})})
    public List<MembershipListItem> getApplicationMembers() {
        this.applicationService.findById(GraviteeContext.getCurrentEnvironment(), this.application);
        return this.membershipService.getMembersByReference(MembershipReferenceType.APPLICATION, this.application).stream().map(MembershipListItem::new).sorted(Comparator.comparing(MembershipListItem::getId)).collect(Collectors.toList());
    }

    @POST
    @Operation(summary="Add or update an application member", description="User must have the MANAGE_MEMBERS permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Member has been added or updated successfully"), @ApiResponse(responseCode="400", description="Membership parameter is not valid"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_MEMBER, acls={RolePermissionAction.CREATE}), @Permission(value=RolePermission.APPLICATION_MEMBER, acls={RolePermissionAction.UPDATE})})
    public Response addOrUpdateApplicationMember(@Valid @NotNull ApplicationMembership applicationMembership) {
        MemberEntity userMember;
        if (SystemRole.PRIMARY_OWNER.name().equals(applicationMembership.getRole())) {
            throw new SinglePrimaryOwnerException(RoleScope.APPLICATION);
        }
        this.applicationService.findById(GraviteeContext.getCurrentEnvironment(), this.application);
        MembershipService.MembershipReference reference = new MembershipService.MembershipReference(MembershipReferenceType.APPLICATION, this.application);
        MembershipService.MembershipMember member = new MembershipService.MembershipMember(applicationMembership.getId(), applicationMembership.getReference(), MembershipMemberType.USER);
        MembershipService.MembershipRole role = new MembershipService.MembershipRole(RoleScope.APPLICATION, applicationMembership.getRole());
        MemberEntity membership = null;
        if (applicationMembership.getId() != null && (userMember = this.membershipService.getUserMember(GraviteeContext.getCurrentEnvironment(), MembershipReferenceType.APPLICATION, this.application, applicationMembership.getId())) != null && userMember.getRoles() != null && !userMember.getRoles().isEmpty()) {
            membership = this.membershipService.updateRoleToMemberOnReference(GraviteeContext.getCurrentOrganization(), GraviteeContext.getCurrentEnvironment(), reference, member, role);
        }
        if (membership == null) {
            this.membershipService.addRoleToMemberOnReference(GraviteeContext.getCurrentOrganization(), GraviteeContext.getCurrentEnvironment(), reference, member, role);
        }
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    @DELETE
    @Operation(summary="Remove an application member", description="User must have the MANAGE_MEMBERS permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Member has been removed successfully"), @ApiResponse(responseCode="400", description="User does not exist"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_MEMBER, acls={RolePermissionAction.DELETE})})
    public Response deleteApplicationMember(@Parameter(name="user", required=true) @NotNull @QueryParam(value="user") String userId) {
        this.applicationService.findById(GraviteeContext.getCurrentEnvironment(), this.application);
        try {
            this.userService.findById(userId);
        }
        catch (UserNotFoundException unfe) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)unfe.getMessage()).build();
        }
        this.membershipService.deleteReferenceMember(GraviteeContext.getCurrentOrganization(), GraviteeContext.getCurrentEnvironment(), MembershipReferenceType.APPLICATION, this.application, MembershipMemberType.USER, userId);
        return Response.ok().build();
    }

    @POST
    @Path(value="transfer_ownership")
    @Operation(summary="Transfer the ownership of the APPLICATION", description="User must have the TRANSFER_OWNERSHIP permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ownership has been transferred successfully"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_MEMBER, acls={RolePermissionAction.UPDATE})})
    public Response transferApplicationOwnership(@Valid @NotNull TransferOwnership transferOwnership) {
        ArrayList<RoleEntity> newRoles = new ArrayList<RoleEntity>();
        Optional optNewPORole = this.roleService.findByScopeAndName(RoleScope.APPLICATION, transferOwnership.getPoRole());
        if (optNewPORole.isPresent()) {
            newRoles.add((RoleEntity)optNewPORole.get());
        }
        this.applicationService.findById(GraviteeContext.getCurrentEnvironment(), this.application);
        this.membershipService.transferApplicationOwnership(GraviteeContext.getCurrentOrganization(), GraviteeContext.getCurrentEnvironment(), this.application, new MembershipService.MembershipMember(transferOwnership.getId(), transferOwnership.getReference(), MembershipMemberType.USER), newRoles);
        return Response.ok().build();
    }
}

