/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.alert.AlertReferenceType;
import io.gravitee.rest.api.model.alert.AlertStatusEntity;
import io.gravitee.rest.api.model.alert.AlertTriggerEntity;
import io.gravitee.rest.api.model.alert.NewAlertTriggerEntity;
import io.gravitee.rest.api.model.alert.UpdateAlertTriggerEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.AlertService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Tag(name="Application Alerts")
public class ApplicationAlertsResource
extends AbstractResource {
    @Inject
    private AlertService alertService;
    @PathParam(value="application")
    @Parameter(name="application", hidden=true)
    private String application;

    @GET
    @Operation(summary="List configured alerts of an application", description="User must have the APPLICATION_ALERT[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of alerts", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=AlertTriggerEntity.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Produces(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_ALERT, acls={RolePermissionAction.READ})})
    public List<AlertTriggerEntity> getApplicationAlerts(@QueryParam(value="event_counts") @DefaultValue(value="true") Boolean withEventCounts) {
        return withEventCounts != false ? this.alertService.findByReferenceWithEventCounts(AlertReferenceType.APPLICATION, this.application) : this.alertService.findByReference(AlertReferenceType.APPLICATION, this.application);
    }

    @GET
    @Path(value="status")
    @Operation(summary="Get alerting status", description="User must have the MANAGEMENT_ALERT[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Alerting status", content={@Content(mediaType="application/json", schema=@Schema(implementation=AlertStatusEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Produces(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_ALERT, acls={RolePermissionAction.READ})})
    public AlertStatusEntity getApplicationAlertsStatus() {
        return this.alertService.getStatus();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create an alert for an application", description="User must have the APPLICATION_ALERT[CREATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Alert successfully created", content={@Content(mediaType="application/json", schema=@Schema(implementation=AlertTriggerEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_ALERT, acls={RolePermissionAction.CREATE})})
    public AlertTriggerEntity createApplicationAlert(@Valid @NotNull NewAlertTriggerEntity alertEntity) {
        alertEntity.setReferenceType(AlertReferenceType.APPLICATION);
        alertEntity.setReferenceId(this.application);
        return this.alertService.create(alertEntity);
    }

    @Path(value="{alert}")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update an alert for an application", description="User must have the APPLICATION_ALERT[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Alert successfully updated", content={@Content(mediaType="application/json", schema=@Schema(implementation=AlertTriggerEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_ALERT, acls={RolePermissionAction.UPDATE})})
    public AlertTriggerEntity updateApplicationAlert(@PathParam(value="alert") String alert, @Valid @NotNull UpdateAlertTriggerEntity alertEntity) {
        alertEntity.setId(alert);
        alertEntity.setReferenceType(AlertReferenceType.APPLICATION);
        alertEntity.setReferenceId(this.application);
        return this.alertService.update(alertEntity);
    }

    @Path(value="{alert}")
    @DELETE
    @Consumes(value={"application/json"})
    @Operation(summary="Delete an alert for an application", description="User must have the APPLICATION_ALERT[DELETE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Alert successfully deleted", content={@Content(mediaType="application/json", schema=@Schema(implementation=AlertTriggerEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_ALERT, acls={RolePermissionAction.DELETE})})
    public void deleteApplicationAlert(@PathParam(value="alert") String alert) {
        this.alertService.delete(alert, this.application);
    }
}

