/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.api.header.ApiHeaderEntity;
import io.gravitee.rest.api.model.api.header.UpdateApiHeaderEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.ApiHeaderService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.PUT;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Tag(name="Configuration")
public class ApiHeaderResource
extends AbstractResource {
    @Inject
    private ApiHeaderService apiHeaderService;

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update an API header", description="User must have the PORTAL_API_HEADER[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="API header successfully updated", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiHeaderEntity.class))}), @ApiResponse(responseCode="404", description="API header not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_API_HEADER, acls={RolePermissionAction.UPDATE})})
    public ApiHeaderEntity updateApiHeader(@PathParam(value="id") String id, @Valid @NotNull UpdateApiHeaderEntity updateApiHeaderEntity) {
        updateApiHeaderEntity.setId(id);
        return this.apiHeaderService.update(GraviteeContext.getCurrentEnvironment(), updateApiHeaderEntity);
    }

    @DELETE
    @Consumes(value={"application/json"})
    @Operation(summary="Delete an API header", description="User must have the PORTAL_API_HEADER[DELETE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="API header successfully deleted"), @ApiResponse(responseCode="404", description="API header not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_API_HEADER, acls={RolePermissionAction.DELETE})})
    public void deleteApiHeader(@PathParam(value="id") String id) {
        this.apiHeaderService.delete(GraviteeContext.getCurrentEnvironment(), id);
    }
}

