/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.common.data.domain.Page;
import io.gravitee.repository.management.model.Event;
import io.gravitee.rest.api.management.rest.model.wrapper.EventEntityPage;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.ApiEventResource;
import io.gravitee.rest.api.management.rest.resource.param.EventSearchParam;
import io.gravitee.rest.api.management.rest.resource.param.EventTypeListParam;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.EventEntity;
import io.gravitee.rest.api.model.EventQuery;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.EventService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.Explode;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.BeanParam;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;

@Tag(name="API Events")
public class ApiEventsResource
extends AbstractResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private EventService eventService;
    @PathParam(value="api")
    @Parameter(name="api", hidden=true)
    private String api;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Get API's events", description="User must have the MANAGE_LIFECYCLE permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="API's events", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=EventEntity.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_EVENT, acls={RolePermissionAction.READ})})
    public List<EventEntity> getApiEventsEvents(@Parameter(explode=Explode.FALSE, schema=@Schema(type="array")) @QueryParam(value="type") EventTypeListParam eventTypeListParam) {
        EventQuery query = new EventQuery();
        query.setApi(this.api);
        return this.eventService.search(query).stream().filter(event -> eventTypeListParam.contains(event.getType())).sorted((e1, e2) -> e2.getCreatedAt().compareTo(e1.getCreatedAt())).collect(Collectors.toList());
    }

    @Path(value="{eventId}")
    public ApiEventResource getApiEventResource() {
        return (ApiEventResource)this.resourceContext.getResource(ApiEventResource.class);
    }

    @GET
    @Path(value="search")
    @Produces(value={"application/json"})
    @Operation(summary="Get API's events", description="User must have the API_EVENT[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Page of API events", content={@Content(mediaType="application/json", schema=@Schema(implementation=EventEntityPage.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_EVENT, acls={RolePermissionAction.READ})})
    public EventEntityPage searchApiEvents(@Parameter @BeanParam EventSearchParam eventSearchParam) {
        ApiEntity apiEntity = this.apiService.findById(this.api);
        HashMap<String, List<String>> properties = new HashMap<String, List<String>>();
        properties.put(Event.EventProperties.API_ID.getValue(), Arrays.asList(this.api));
        Page apiEvents = this.eventService.search((List)eventSearchParam.getEventTypeListParam(), properties, eventSearchParam.getFrom().longValue(), eventSearchParam.getTo().longValue(), eventSearchParam.getPage().intValue(), eventSearchParam.getSize().intValue(), Collections.singletonList(GraviteeContext.getCurrentEnvironment()));
        apiEvents.getContent().forEach(event -> {
            Map properties1 = event.getProperties();
            event.setPayload(null);
            properties1.put("api_name", apiEntity.getName());
            properties1.put("api_version", apiEntity.getVersion());
        });
        return new EventEntityPage((Page<EventEntity>)apiEvents);
    }
}

