/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.common.data.domain.Page;
import io.gravitee.rest.api.management.rest.model.wrapper.AlertEventPage;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.param.AlertAnalyticsParam;
import io.gravitee.rest.api.management.rest.resource.param.AlertEventSearchParam;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.AlertAnalyticsQuery;
import io.gravitee.rest.api.model.AlertEventQuery;
import io.gravitee.rest.api.model.alert.AlertAnalyticsEntity;
import io.gravitee.rest.api.model.alert.AlertEventEntity;
import io.gravitee.rest.api.model.alert.AlertReferenceType;
import io.gravitee.rest.api.model.alert.AlertStatusEntity;
import io.gravitee.rest.api.model.alert.AlertTriggerEntity;
import io.gravitee.rest.api.model.alert.NewAlertTriggerEntity;
import io.gravitee.rest.api.model.alert.UpdateAlertTriggerEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.AlertAnalyticsService;
import io.gravitee.rest.api.service.AlertService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Tag(name="API Alerts")
public class ApiAlertsResource
extends AbstractResource {
    @Inject
    private AlertService alertService;
    @Inject
    private AlertAnalyticsService alertAnalyticsService;
    @PathParam(value="api")
    @Parameter(name="api", hidden=true)
    private String api;

    @GET
    @Operation(summary="List alerts of an API", description="User must have the API_ALERT[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of alerts", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=AlertTriggerEntity.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Produces(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.API_ALERT, acls={RolePermissionAction.READ})})
    public List<AlertTriggerEntity> getApiAlerts(@QueryParam(value="event_counts") @DefaultValue(value="true") Boolean withEventCounts) {
        return withEventCounts != false ? this.alertService.findByReferenceWithEventCounts(AlertReferenceType.API, this.api) : this.alertService.findByReference(AlertReferenceType.API, this.api);
    }

    @GET
    @Path(value="status")
    @Operation(summary="Get alerting status", description="User must have the MANAGEMENT_ALERT[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Alerting status", content={@Content(mediaType="application/json", schema=@Schema(implementation=AlertStatusEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Produces(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.API_ALERT, acls={RolePermissionAction.READ})})
    public AlertStatusEntity getApiAlertsStatus() {
        return this.alertService.getStatus();
    }

    @GET
    @Path(value="analytics")
    @Operation(summary="List configured alerts of the API", description="User must have the API_ALERT[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of alerts", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=AlertTriggerEntity.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Produces(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.API_ALERT, acls={RolePermissionAction.READ})})
    public AlertAnalyticsEntity getPlatformAlertsAnalytics(@BeanParam AlertAnalyticsParam param) {
        param.validate();
        return this.alertAnalyticsService.findByReference(AlertReferenceType.API, this.api, new AlertAnalyticsQuery.Builder().from(param.getFrom().longValue()).to(param.getTo().longValue()).build());
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create an alert for an API", description="User must have the API_ALERT[CREATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Alert successfully created", content={@Content(mediaType="application/json", schema=@Schema(implementation=AlertTriggerEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_ALERT, acls={RolePermissionAction.CREATE})})
    public AlertTriggerEntity createApiAlert(@Valid @NotNull NewAlertTriggerEntity alertEntity) {
        alertEntity.setReferenceType(AlertReferenceType.API);
        alertEntity.setReferenceId(this.api);
        return this.alertService.create(alertEntity);
    }

    @Path(value="{alert}")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update an alert for an API", description="User must have the API_ALERT[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Alert successfully updated", content={@Content(mediaType="application/json", schema=@Schema(implementation=AlertTriggerEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_ALERT, acls={RolePermissionAction.UPDATE})})
    public AlertTriggerEntity updateApiAlert(@PathParam(value="alert") String alert, @Valid @NotNull UpdateAlertTriggerEntity alertEntity) {
        alertEntity.setId(alert);
        alertEntity.setReferenceType(AlertReferenceType.API);
        alertEntity.setReferenceId(this.api);
        return this.alertService.update(alertEntity);
    }

    @Path(value="{alert}")
    @DELETE
    @Consumes(value={"application/json"})
    @Operation(summary="Delete an alert for an API", description="User must have the API_ALERT[DELETE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Alert successfully deleted", content={@Content(mediaType="application/json", schema=@Schema(implementation=AlertTriggerEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_ALERT, acls={RolePermissionAction.DELETE})})
    public void deleteApiAlert(@PathParam(value="alert") String alert) {
        this.alertService.delete(alert, this.api);
    }

    @GET
    @Path(value="{alert}/events")
    @Operation(summary="Retrieve the list of events for an alert", description="User must have the MANAGEMENT_ALERT[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of events", content={@Content(mediaType="application/json", schema=@Schema(implementation=AlertEventPage.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Produces(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.API_ALERT, acls={RolePermissionAction.READ})})
    public AlertEventPage getApiAlertEvents(@PathParam(value="alert") String alert, @BeanParam AlertEventSearchParam param) {
        return new AlertEventPage((Page<AlertEventEntity>)this.alertService.findEvents(alert, new AlertEventQuery.Builder().from(param.getFrom().longValue()).to(param.getTo().longValue()).pageNumber(param.getPage().intValue()).pageSize(param.getSize().intValue()).build()));
    }
}

