/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.configuration.identity;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.configuration.identity.IdentityProviderEntity;
import io.gravitee.rest.api.model.configuration.identity.UpdateIdentityProviderEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.configuration.identity.IdentityProviderService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;

@Api(tags={"Configuration", "Identity Providers"})
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class IdentityProviderResource
extends AbstractResource {
    @Autowired
    private IdentityProviderService identityProviderService;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Get an identity provider", notes="User must have the ORGANIZATION_IDENTITY_PROVIDER[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="An identity provider"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_IDENTITY_PROVIDER, acls={RolePermissionAction.READ})})
    public IdentityProviderEntity getIdentityProvider(@PathParam(value="identityProvider") String identityProvider) {
        return this.identityProviderService.findById(identityProvider);
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update an identity provider", notes="User must have the ORGANIZATION_IDENTITY_PROVIDER[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Updated identity provider", response=IdentityProviderEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_IDENTITY_PROVIDER, acls={RolePermissionAction.UPDATE})})
    public IdentityProviderEntity updateIdentityProvider(@PathParam(value="identityProvider") String identityProvider, @ApiParam(name="identityProviderEntity", required=true) @Valid @NotNull UpdateIdentityProviderEntity updatedIdentityProvider) {
        return this.identityProviderService.update(identityProvider, updatedIdentityProvider);
    }

    @DELETE
    @ApiOperation(value="Delete an identity provider", notes="User must have the ORGANIZATION_IDENTITY_PROVIDER[DELETE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=204, message="Identity provider successfully deleted"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_IDENTITY_PROVIDER, acls={RolePermissionAction.DELETE})})
    public Response deleteIdentityProvider(@PathParam(value="identityProvider") String identityProvider) {
        this.identityProviderService.delete(identityProvider);
        return Response.noContent().build();
    }
}

