/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.platform.plugin.PluginEntity;
import io.gravitee.rest.api.service.ServiceDiscoveryService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;

@Api(tags={"Plugins"})
public class ServiceDiscoveryResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private ServiceDiscoveryService serviceDiscoveryService;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a service discovery", notes="User must have the MANAGEMENT_API[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Service discovery plugin", response=PluginEntity.class), @ApiResponse(code=404, message="Resource not found"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_API, acls={RolePermissionAction.READ})})
    public PluginEntity getServiceDiscovery(@PathParam(value="plugin") String pluginId) {
        return this.serviceDiscoveryService.findById(pluginId);
    }

    @GET
    @Path(value="schema")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a service discovery's schema", notes="User must have the MANAGEMENT_API[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Service discovery plugin's schema"), @ApiResponse(code=404, message="Service discovery not found"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_API, acls={RolePermissionAction.READ})})
    public String getServiceDiscoverySchema(@PathParam(value="plugin") String pluginId) {
        this.serviceDiscoveryService.findById(pluginId);
        return this.serviceDiscoveryService.getSchema(pluginId);
    }
}

