/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.PromotionResource;
import io.gravitee.rest.api.model.common.Sortable;
import io.gravitee.rest.api.model.common.SortableImpl;
import io.gravitee.rest.api.model.promotion.PromotionEntity;
import io.gravitee.rest.api.model.promotion.PromotionEntityStatus;
import io.gravitee.rest.api.model.promotion.PromotionQuery;
import io.gravitee.rest.api.service.promotion.PromotionService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Api(tags={"Promotions"})
public class PromotionsResource
extends AbstractResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private PromotionService promotionService;

    @Path(value="{promotion}")
    public PromotionResource getPolicyResource() {
        return (PromotionResource)this.resourceContext.getResource(PromotionResource.class);
    }

    @POST
    @Path(value="_search")
    @Produces(value={"application/json"})
    @ApiOperation(value="Search for Promotion")
    @ApiResponses(value={@ApiResponse(code=200, message="List promotions matching request parameters", response=PromotionEntity.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error")})
    public Response searchPromotions(@ApiParam(name="statuses", required=true) @NotNull @QueryParam(value="statuses") List<String> statuses, @ApiParam(name="apiId", required=true) @NotNull @QueryParam(value="apiId") String apiId) {
        PromotionQuery promotionQuery = new PromotionQuery();
        promotionQuery.setStatuses(statuses.stream().map(PromotionEntityStatus::valueOf).collect(Collectors.toList()));
        promotionQuery.setApiId(apiId);
        List promotions = this.promotionService.search(promotionQuery, (Sortable)new SortableImpl("created_at", false), null).getContent();
        return Response.ok().entity((Object)promotions).build();
    }
}

