/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.model.InstallationStatus;
import io.gravitee.rest.api.model.promotion.PromotionTargetEntity;
import io.gravitee.rest.api.service.InstallationService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.InstallationNotAcceptedException;
import io.gravitee.rest.api.service.promotion.PromotionService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Api(tags={"Promotion"})
public class PromotionTargetsResource
extends AbstractResource {
    @Inject
    private PromotionService promotionService;
    @Inject
    private InstallationService installationService;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="List available targets (environments) for a promotion")
    @ApiResponses(value={@ApiResponse(code=200, message="List of promotion targets", response=PromotionTargetEntity.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=503, message="Installation not connected to cockpit")})
    public Response getPromotionTargets() {
        InstallationStatus status = this.installationService.getInstallationStatus();
        if (InstallationStatus.ACCEPTED == status) {
            List promotionTargetEntities = this.promotionService.listPromotionTargets(GraviteeContext.getCurrentOrganization(), GraviteeContext.getCurrentEnvironment());
            return Response.ok((Object)promotionTargetEntities).build();
        }
        throw new InstallationNotAcceptedException(this.installationService.get(), status);
    }
}

