/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.settings.PortalSettingsEntity;
import io.gravitee.rest.api.service.ConfigService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Api(tags={"Settings"})
public class PortalSettingsResource {
    @Inject
    private ConfigService configService;
    @Context
    private ResourceContext resourceContext;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the portal settings")
    @ApiResponses(value={@ApiResponse(code=200, message="Portal configuration", response=PortalSettingsEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_SETTINGS, acls={RolePermissionAction.READ})})
    public PortalSettingsEntity getPortalSettings() {
        return this.configService.getPortalSettings(GraviteeContext.getCurrentEnvironment());
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Save the portal settings")
    @ApiResponses(value={@ApiResponse(code=200, message="Updated portal settings", response=PortalSettingsEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_SETTINGS, acls={RolePermissionAction.CREATE, RolePermissionAction.UPDATE, RolePermissionAction.DELETE})})
    public Response savePortalSettings(@ApiParam(name="config", required=true) @NotNull PortalSettingsEntity portalSettingsEntity) {
        this.configService.save(GraviteeContext.getCurrentEnvironment(), portalSettingsEntity);
        return Response.ok().entity((Object)portalSettingsEntity).build();
    }
}

