/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.PortalPageMediaResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.management.rest.utils.HttpHeadersUtil;
import io.gravitee.rest.api.model.ImportPageEntity;
import io.gravitee.rest.api.model.NewPageEntity;
import io.gravitee.rest.api.model.PageEntity;
import io.gravitee.rest.api.model.PageType;
import io.gravitee.rest.api.model.UpdatePageEntity;
import io.gravitee.rest.api.model.documentation.PageQuery;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.AccessControlService;
import io.gravitee.rest.api.service.ConfigService;
import io.gravitee.rest.api.service.PageService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.PageSystemFolderActionException;
import io.gravitee.rest.api.service.exceptions.UnauthorizedAccessException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Api(tags={"Portal Pages"})
public class PortalPagesResource
extends AbstractResource {
    @Inject
    private PageService pageService;
    @Inject
    private AccessControlService accessControlService;
    @Inject
    private ConfigService configService;
    @Context
    private ResourceContext resourceContext;

    @GET
    @Path(value="/{page}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a page", notes="Every users can use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Page"), @ApiResponse(code=500, message="Internal server error")})
    public PageEntity getPortalPage(@HeaderParam(value="Accept-Language") String acceptLang, @PathParam(value="page") String page, @QueryParam(value="portal") boolean portal, @QueryParam(value="translated") boolean translated) {
        String acceptedLocale = HttpHeadersUtil.getFirstAcceptedLocaleName(acceptLang);
        PageEntity pageEntity = this.pageService.findById(page, translated ? acceptedLocale : null);
        if (this.isDisplayable(pageEntity)) {
            if (!this.isAuthenticated() && pageEntity.getMetadata() != null) {
                pageEntity.getMetadata().clear();
            }
            if (portal) {
                this.pageService.transformWithTemplate(pageEntity, null);
            }
            return pageEntity;
        }
        throw new UnauthorizedAccessException();
    }

    @GET
    @Path(value="/{page}/content")
    @ApiOperation(value="Get the page's content", notes="Every users can use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Page's content"), @ApiResponse(code=500, message="Internal server error")})
    public Response getPortalPageContent(@PathParam(value="page") String page) {
        PageEntity pageEntity = this.pageService.findById(page);
        if (this.isDisplayable(pageEntity)) {
            this.pageService.transformSwagger(pageEntity);
            return Response.ok((Object)pageEntity.getContent(), (String)pageEntity.getContentType()).build();
        }
        throw new UnauthorizedAccessException();
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="List pages", notes="Every users can use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="List of pages", response=PageEntity.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error")})
    public List<PageEntity> getPortalPages(@HeaderParam(value="Accept-Language") String acceptLang, @QueryParam(value="homepage") Boolean homepage, @QueryParam(value="published") Boolean published, @QueryParam(value="type") PageType type, @QueryParam(value="parent") String parent, @QueryParam(value="name") String name, @QueryParam(value="root") Boolean rootParent, @QueryParam(value="translated") boolean translated) {
        String acceptedLocale = HttpHeadersUtil.getFirstAcceptedLocaleName(acceptLang);
        return this.pageService.search(new PageQuery.Builder().homepage(homepage).published(published).type(type).parent(parent).name(name).rootParent(rootParent).build(), translated ? acceptedLocale : null, GraviteeContext.getCurrentEnvironment()).stream().filter(this::isDisplayable).collect(Collectors.toList());
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a page", notes="User must have the ENVIRONMENT_DOCUMENTATION[CREATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=201, message="Page successfully created", response=PageEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_DOCUMENTATION, acls={RolePermissionAction.CREATE})})
    public Response createPortalPage(@ApiParam(name="page", required=true) @Valid @NotNull NewPageEntity newPageEntity) {
        if (newPageEntity.getType().equals((Object)PageType.SYSTEM_FOLDER)) {
            throw new PageSystemFolderActionException("Create");
        }
        int order = this.pageService.findMaxPortalPageOrder(GraviteeContext.getCurrentEnvironment()) + 1;
        newPageEntity.setOrder(order);
        newPageEntity.setLastContributor(this.getAuthenticatedUser());
        PageEntity newPage = this.pageService.createPage(newPageEntity, GraviteeContext.getCurrentEnvironment());
        if (newPage != null) {
            return Response.created((URI)this.getLocationHeader(newPage.getId())).entity((Object)newPage).build();
        }
        return Response.serverError().build();
    }

    @PUT
    @Path(value="/{page}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update a page", notes="User must have the ENVIRONMENT_DOCUMENTATION[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=201, message="Page successfully updated", response=PageEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_DOCUMENTATION, acls={RolePermissionAction.UPDATE})})
    public PageEntity updatePortalPage(@PathParam(value="page") String page, @ApiParam(name="page", required=true) @Valid @NotNull UpdatePageEntity updatePageEntity) {
        PageEntity existingPage = this.pageService.findById(page);
        if (existingPage.getType().equals(PageType.SYSTEM_FOLDER.name())) {
            throw new PageSystemFolderActionException("Update");
        }
        updatePageEntity.setLastContributor(this.getAuthenticatedUser());
        return this.pageService.update(page, updatePageEntity);
    }

    @PUT
    @Path(value="/{page}/content")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update a page content", notes="User must have the PORTAL_DOCUMENTATION[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Page content successfully updated"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_DOCUMENTATION, acls={RolePermissionAction.UPDATE})})
    public String updatePageContent(@PathParam(value="page") String page, @ApiParam(name="content", required=true) @Valid @NotNull String content) {
        this.pageService.findById(page);
        UpdatePageEntity updatePageEntity = new UpdatePageEntity();
        updatePageEntity.setContent(content);
        PageEntity update = this.pageService.update(page, updatePageEntity, true);
        return update.getContent();
    }

    @PATCH
    @Path(value="/{page}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update a page", notes="User must have the ENVIRONMENT_DOCUMENTATION[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=201, message="Page successfully updated", response=PageEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_DOCUMENTATION, acls={RolePermissionAction.UPDATE})})
    public PageEntity partialUpdatePortalPage(@PathParam(value="page") String page, @ApiParam(name="page", required=true) @NotNull UpdatePageEntity updatePageEntity) {
        PageEntity existingPage = this.pageService.findById(page);
        if (existingPage.getType().equals(PageType.SYSTEM_FOLDER.name())) {
            throw new PageSystemFolderActionException("Update");
        }
        updatePageEntity.setLastContributor(this.getAuthenticatedUser());
        return this.pageService.update(page, updatePageEntity, true);
    }

    @POST
    @Path(value="/{page}/_fetch")
    @Produces(value={"application/json"})
    @ApiOperation(value="Refresh page by calling the associated fetcher", notes="User must have the ENVIRONMENT_DOCUMENTATION[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=201, message="Page successfully refreshed", response=PageEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_DOCUMENTATION, acls={RolePermissionAction.UPDATE})})
    public PageEntity fetchPortalPage(@PathParam(value="page") String page) {
        this.pageService.findById(page);
        String contributor = this.getAuthenticatedUser();
        return this.pageService.fetch(page, contributor);
    }

    @POST
    @Path(value="/_fetch")
    @Produces(value={"application/json"})
    @ApiOperation(value="Refresh all pages by calling their associated fetcher", notes="User must have the ENVIRONMENT_DOCUMENTATION[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=201, message="Pages successfully refreshed", response=PageEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_DOCUMENTATION, acls={RolePermissionAction.UPDATE})})
    public Response fetchAllPortalPages() {
        String contributor = this.getAuthenticatedUser();
        this.pageService.fetchAll(new PageQuery.Builder().build(), contributor, GraviteeContext.getCurrentEnvironment());
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="/{page}")
    @ApiOperation(value="Delete a page", notes="User must have the ENVIRONMENT_DOCUMENTATION[DELETE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=204, message="Page successfully deleted"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_DOCUMENTATION, acls={RolePermissionAction.DELETE})})
    public void deletePortalPage(@PathParam(value="page") String page) {
        PageEntity existingPage = this.pageService.findById(page);
        if (existingPage.getType().equals(PageType.SYSTEM_FOLDER.name())) {
            throw new PageSystemFolderActionException("Delete");
        }
        this.pageService.delete(page);
    }

    @POST
    @Path(value="/_import")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Import pages", notes="User must have the ENVIRONMENT_DOCUMENTATION[CREATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=201, message="Page successfully created", response=PageEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_DOCUMENTATION, acls={RolePermissionAction.CREATE})})
    public List<PageEntity> importPortalPageFromFiles(@ApiParam(name="page", required=true) @Valid @NotNull ImportPageEntity importPageEntity) {
        importPageEntity.setLastContributor(this.getAuthenticatedUser());
        return this.pageService.importFiles(importPageEntity, GraviteeContext.getCurrentEnvironment());
    }

    @PUT
    @Path(value="/_import")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Import pages", notes="User must have the ENVIRONMENT_DOCUMENTATION[CREATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=201, message="Page successfully updated", response=PageEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_DOCUMENTATION, acls={RolePermissionAction.CREATE})})
    public List<PageEntity> updateImportedPortalPageFromFiles(@ApiParam(name="page", required=true) @Valid @NotNull ImportPageEntity importPageEntity) {
        importPageEntity.setLastContributor(this.getAuthenticatedUser());
        return this.pageService.importFiles(importPageEntity, GraviteeContext.getCurrentEnvironment());
    }

    private boolean isDisplayable(PageEntity pageEntity) {
        if (!this.isAuthenticated() && this.configService.portalLoginForced(GraviteeContext.getCurrentEnvironment())) {
            return false;
        }
        if (this.isAuthenticated() && this.isAdmin()) {
            return true;
        }
        return this.accessControlService.canAccessPageFromPortal(GraviteeContext.getCurrentEnvironment(), pageEntity);
    }

    @Path(value="/{page}/media")
    public PortalPageMediaResource getPortalPageMediaResource() {
        return (PortalPageMediaResource)this.resourceContext.getResource(PortalPageMediaResource.class);
    }
}

