/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.MediaEntity;
import io.gravitee.rest.api.model.PageEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.MediaService;
import io.gravitee.rest.api.service.PageService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.UploadUnauthorized;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;

@Api(tags={"Portal Media"})
public class PortalPageMediaResource
extends AbstractResource {
    @Inject
    private MediaService mediaService;
    @Inject
    private PageService pageService;
    @PathParam(value="page")
    @ApiParam(name="page", required=true)
    private String page;

    @POST
    @ApiOperation(value="Attach a media to a portal page ", notes="User must have the ENVIRONMENT_DOCUMENTATION[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=201, message="Media successfully added", response=PageEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_DOCUMENTATION, acls={RolePermissionAction.UPDATE})})
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    public Response attachPortalPageMedia(@Context HttpServletRequest request, @FormDataParam(value="file") InputStream uploadedInputStream, @FormDataParam(value="file") FormDataContentDisposition fileDetail, @FormDataParam(value="file") FormDataBodyPart body, @FormDataParam(value="fileName") String fileName) throws IOException {
        if ((long)request.getContentLength() > this.mediaService.getMediaMaxSize(GraviteeContext.getCurrentEnvironment())) {
            throw new UploadUnauthorized("Max size is " + this.mediaService.getMediaMaxSize(GraviteeContext.getCurrentEnvironment()) + "bytes. Actual size is " + request.getContentLength() + "bytes.");
        }
        String originalFileName = fileDetail.getFileName();
        MediaEntity mediaEntity = new MediaEntity();
        mediaEntity.setSize(fileDetail.getSize());
        mediaEntity.setType(body.getMediaType().getType());
        mediaEntity.setSubType(body.getMediaType().getSubtype());
        mediaEntity.setData(IOUtils.toByteArray((InputStream)uploadedInputStream));
        mediaEntity.setFileName(originalFileName);
        String mediaId = this.mediaService.savePortalMedia(mediaEntity);
        this.pageService.attachMedia(this.page, mediaId, fileName == null ? originalFileName : fileName);
        mediaEntity.setData(null);
        return Response.ok((Object)mediaEntity).build();
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve all media for a Portal page", notes="User must have the ENVIRONMENT_DOCUMENTATION[READ] permission to use this service")
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_DOCUMENTATION, acls={RolePermissionAction.READ})})
    public Response getPortalPageMedia() {
        PageEntity currentPage = this.pageService.findById(this.page);
        List pageMedia = this.mediaService.findAllWithoutContent(currentPage.getAttachedMedia());
        if (pageMedia != null && !pageMedia.isEmpty()) {
            return Response.ok((Object)pageMedia).build();
        }
        return Response.noContent().build();
    }
}

