/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.PolicyEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.PolicyService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;

@Api(tags={"Plugins"})
public class PolicyResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private PolicyService policyService;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a policy", notes="User must have the MANAGEMENT_API[READ] permission to use this service")
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_API, acls={RolePermissionAction.READ})})
    public PolicyEntity getPolicy(@PathParam(value="policy") String policy) {
        return (PolicyEntity)this.policyService.findById(policy);
    }

    @GET
    @Path(value="schema")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a policy's schema", notes="User must have the MANAGEMENT_API[READ] permission to use this service")
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_API, acls={RolePermissionAction.READ})})
    public String getPolicySchema(@PathParam(value="policy") String policy) {
        this.policyService.findById(policy);
        return this.policyService.getSchema(policy);
    }

    @GET
    @Path(value="icon")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get a policy's icon", notes="User must have the MANAGEMENT_API[READ] permission to use this service")
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_API, acls={RolePermissionAction.READ})})
    public String getPolicyIcon(@PathParam(value="policy") String policy) {
        this.policyService.findById(policy);
        return this.policyService.getIcon(policy);
    }

    @GET
    @Path(value="documentation")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get a policy's documentation", notes="User must have the MANAGEMENT_API[READ] permission to use this service")
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_API, acls={RolePermissionAction.READ})})
    public String getPolicyDoc(@PathParam(value="policy") String policy) {
        this.policyService.findById(policy);
        return this.policyService.getDocumentation(policy);
    }
}

