/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.monitoring.MonitoringData;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.MonitoringService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Api(tags={"Gateway"})
public class MonitoringResource
extends AbstractResource {
    @Inject
    private MonitoringService monitoringService;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Get monitoring metrics for a gateway instance")
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_PLATFORM, acls={RolePermissionAction.READ})})
    public MonitoringData getInstanceMonitoring(@PathParam(value="gatewayId") String gatewayId) {
        return this.monitoringService.findMonitoring(gatewayId);
    }
}

