/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.MessageEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.MessageService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Api(tags={"Messages"})
public class MessagesResource
extends AbstractResource {
    @Inject
    private MessageService messageService;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Send a message to users depending on their profile", notes="User must have the MANAGEMENT_MESSAGE[CREATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Message successfully sent", response=MessageEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_MESSAGE, acls={RolePermissionAction.CREATE})})
    public Response createMessage(MessageEntity message) {
        return Response.ok((Object)this.messageService.create(GraviteeContext.getExecutionContext(), message)).build();
    }
}

