/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.common.data.domain.Page;
import io.gravitee.rest.api.management.rest.resource.InstanceResource;
import io.gravitee.rest.api.management.rest.resource.param.InstanceSearchParam;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.InstanceListItem;
import io.gravitee.rest.api.model.InstanceQuery;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.InstanceService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.inject.Inject;
import javax.ws.rs.BeanParam;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;

@Api(tags={"Gateway"})
public class InstancesResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private InstanceService instanceService;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="List gateway instances")
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_INSTANCE, acls={RolePermissionAction.READ})})
    public Page<InstanceListItem> getInstances(@BeanParam InstanceSearchParam param) {
        InstanceQuery query = new InstanceQuery();
        query.setIncludeStopped(param.isIncludeStopped());
        query.setFrom(param.getFrom().longValue());
        query.setTo(param.getTo().longValue());
        query.setPage(param.getPage().intValue());
        query.setSize(param.getSize().intValue());
        return this.instanceService.search(query);
    }

    @Path(value="{instance}")
    public InstanceResource getInstanceResource() {
        return (InstanceResource)this.resourceContext.getResource(InstanceResource.class);
    }
}

