/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.GroupInvitationsResource;
import io.gravitee.rest.api.management.rest.resource.GroupMembersResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.GroupEntity;
import io.gravitee.rest.api.model.UpdateGroupEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.service.GroupService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.ForbiddenAccessException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Api(tags={"Groups"})
public class GroupResource
extends AbstractResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private GroupService groupService;
    @PathParam(value="group")
    @ApiParam(name="group", required=true)
    private String group;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a group")
    @ApiResponses(value={@ApiResponse(code=200, message="Group definition", response=GroupEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_GROUP, acls={RolePermissionAction.READ})})
    public GroupEntity getGroup() {
        return this.groupService.findById(GraviteeContext.getCurrentEnvironment(), this.group);
    }

    @DELETE
    @ApiOperation(value="Delete an existing group")
    @ApiResponses(value={@ApiResponse(code=204, message="Group successfully deleted"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_GROUP, acls={RolePermissionAction.DELETE})})
    public Response deleteGroup() {
        this.checkRights();
        this.groupService.delete(GraviteeContext.getCurrentEnvironment(), this.group);
        return Response.noContent().build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update an existing group")
    @ApiResponses(value={@ApiResponse(code=200, message="Group successfully updated", response=GroupEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_GROUP, acls={RolePermissionAction.UPDATE}), @Permission(value=RolePermission.GROUP_MEMBER, acls={RolePermissionAction.UPDATE})})
    public GroupEntity updateGroup(@ApiParam(name="group", required=true) @Valid @NotNull UpdateGroupEntity updateGroupEntity) {
        GroupEntity groupEntity = this.checkRights();
        if (!this.permissionService.hasPermission(RolePermission.ENVIRONMENT_GROUP, GraviteeContext.getCurrentEnvironment(), new RolePermissionAction[]{RolePermissionAction.CREATE, RolePermissionAction.UPDATE, RolePermissionAction.DELETE})) {
            updateGroupEntity.setMaxInvitation(groupEntity.getMaxInvitation());
            updateGroupEntity.setLockApiRole(groupEntity.isLockApiRole());
            updateGroupEntity.setLockApplicationRole(groupEntity.isLockApplicationRole());
            updateGroupEntity.setSystemInvitation(groupEntity.isSystemInvitation());
            updateGroupEntity.setEmailInvitation(groupEntity.isEmailInvitation());
            if (groupEntity.isLockApiRole()) {
                updateGroupEntity.getRoles().put(RoleScope.API, (String)groupEntity.getRoles().get(RoleScope.API));
            }
            if (groupEntity.isLockApplicationRole()) {
                updateGroupEntity.getRoles().put(RoleScope.APPLICATION, (String)groupEntity.getRoles().get(RoleScope.APPLICATION));
            }
        }
        return this.groupService.update(GraviteeContext.getCurrentEnvironment(), this.group, updateGroupEntity);
    }

    @GET
    @Path(value="/memberships")
    @Produces(value={"application/json"})
    @ApiOperation(value="List APIs or applications linked to this group")
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_GROUP, acls={RolePermissionAction.READ})})
    public Response getGroupMemberships(@QueryParam(value="type") String type) {
        if ("api".equalsIgnoreCase(type)) {
            return Response.ok((Object)this.groupService.getApis(GraviteeContext.getCurrentEnvironment(), this.group)).build();
        }
        if ("application".equalsIgnoreCase(type)) {
            return Response.ok((Object)this.groupService.getApplications(this.group)).build();
        }
        return Response.noContent().build();
    }

    @POST
    @Path(value="/memberships")
    @Produces(value={"application/json"})
    @ApiOperation(value="Associate a group to existing APIs or Applications")
    @ApiResponses(value={@ApiResponse(code=200, message="Group successfully updated", response=GroupEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_GROUP, acls={RolePermissionAction.UPDATE})})
    public GroupEntity addGroupMember(@QueryParam(value="type") String type) {
        GroupEntity groupEntity = this.checkRights();
        this.groupService.associate(this.group, type);
        return groupEntity;
    }

    private GroupEntity checkRights() {
        GroupEntity groupEntity = this.getGroup();
        if (!groupEntity.isManageable()) {
            throw new ForbiddenAccessException();
        }
        return groupEntity;
    }

    @Path(value="members")
    public GroupMembersResource groupMembersResource() {
        return (GroupMembersResource)this.resourceContext.getResource(GroupMembersResource.class);
    }

    @Path(value="invitations")
    public GroupInvitationsResource groupInvitationsResource() {
        return (GroupInvitationsResource)this.resourceContext.getResource(GroupInvitationsResource.class);
    }
}

